/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoGourmand;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoGourmand;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.dynamo.GourmandManager;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoGourmand
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 10;
    protected boolean augmentPaleo;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoGourmandPaleo");
        GameRegistry.registerTileEntity(TileDynamoGourmand.class, (String)"thermalexpansion:dynamo_gourmand");
        TileDynamoGourmand.config();
    }

    public static void config() {
        String category = "Dynamo.Gourmand";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Gourmand Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    public TileDynamoGourmand() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.gourmand.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentPaleo) {
            return GourmandManager.getPaleoFuelEnergy(this.inventory[0]) > 0;
        }
        return GourmandManager.getFuelEnergy(this.inventory[0]) > 0;
    }

    @Override
    protected void processStart() {
        this.maxFuelRF = this.augmentPaleo ? GourmandManager.getPaleoFuelEnergy(this.inventory[0]) * this.energyMod / 100 : GourmandManager.getFuelEnergy(this.inventory[0]) * this.energyMod / 100;
        this.fuelRF += this.maxFuelRF;
        this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TETextures.PORTAL_UNDERLAY;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoGourmand(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoGourmand(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, GourmandManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.maxFuelRF;
    }

    @Override
    public int getFuelEnergy(ItemStack stack) {
        return (this.augmentPaleo ? GourmandManager.getPaleoFuelEnergy(stack) : GourmandManager.getFuelEnergy(stack)) * this.energyMod / 100;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxFuelRF = nbt.func_74762_e("FuelMax");
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, GourmandManager.DEFAULT_ENERGY);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.maxFuelRF);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.maxFuelRF);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.maxFuelRF = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentPaleo = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentPaleo && "dynamoGourmandPaleo".equals(id)) {
            this.augmentPaleo = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 4 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.augmentPaleo ? GourmandManager.getPaleoFuelEnergy(stack) > 0 : GourmandManager.getFuelEnergy(stack) > 0;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == null || side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }
}

