/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiLexicon;
import cofh.thermalexpansion.gui.container.device.ContainerLexicon;
import cofh.thermalfoundation.util.LexiconManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileLexicon
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.LEXICON.getMetadata();
    private int inputTracker;
    private int outputTracker;
    private Map<String, ItemStack> preferredStacks = new Object2ObjectOpenHashMap();

    public static void initialize() {
        TileLexicon.SIDE_CONFIGS[TileLexicon.TYPE] = new SideConfig();
        TileLexicon.SIDE_CONFIGS[TileLexicon.TYPE].numConfig = 5;
        TileLexicon.SIDE_CONFIGS[TileLexicon.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileLexicon.SIDE_CONFIGS[TileLexicon.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileLexicon.SIDE_CONFIGS[TileLexicon.TYPE].defaultSides = new byte[]{2, 1, 1, 1, 1, 1};
        TileLexicon.SLOT_CONFIGS[TileLexicon.TYPE] = new SlotConfig();
        TileLexicon.SLOT_CONFIGS[TileLexicon.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileLexicon.SLOT_CONFIGS[TileLexicon.TYPE].allowExtractionSlot = new boolean[]{false, true};
        TileLexicon.LIGHT_VALUES[TileLexicon.TYPE] = 12;
        GameRegistry.registerTileEntity(TileLexicon.class, (String)"thermalexpansion:device_lexicon");
        TileLexicon.config();
    }

    public static void config() {
        String category = "Device.Lexicon";
        BlockDevice.enable[TileLexicon.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileLexicon() {
        this.inventory = new ItemStack[11];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length - 9);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 16L != 0L) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.transmute();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        this.transferOutput();
        this.updateIfChanged(curActive);
    }

    protected void transmute() {
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        if (this.hasPreferredStack(this.inventory[0])) {
            ItemStack transmuteStack = ItemHelper.cloneStack((ItemStack)this.getPreferredStack(this.inventory[0]), (int)this.inventory[0].func_190916_E());
            if (this.inventory[1].func_190926_b()) {
                this.inventory[0] = ItemStack.field_190927_a;
                this.inventory[1] = transmuteStack;
            } else if (this.inventory[1].func_77969_a(transmuteStack)) {
                int total = this.inventory[1].func_190916_E() + transmuteStack.func_190916_E();
                if (total <= this.inventory[1].func_77976_d()) {
                    this.inventory[0] = ItemStack.field_190927_a;
                    this.inventory[1].func_190917_f(transmuteStack.func_190916_E());
                } else {
                    this.inventory[0].func_190918_g(this.inventory[1].func_77976_d() - this.inventory[1].func_190916_E());
                    this.inventory[1].func_190920_e(this.inventory[1].func_77976_d());
                }
            }
        }
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, 64, EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, 64, EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    public void updatePreferredStacks() {
        this.preferredStacks.clear();
        for (int i = 2; i < this.inventory.length; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            this.preferredStacks.put(OreDictionaryArbiter.getOreName((ItemStack)this.inventory[i]), this.inventory[i]);
        }
    }

    public boolean hasPreferredStack(ItemStack stack) {
        return this.preferredStacks.containsKey(OreDictionaryArbiter.getOreName((ItemStack)stack));
    }

    public ItemStack getPreferredStack(ItemStack stack) {
        return this.preferredStacks.get(OreDictionaryArbiter.getOreName((ItemStack)stack));
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiLexicon(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerLexicon(inventory, (TileEntity)this);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.updatePreferredStacks();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || LexiconManager.validOre((ItemStack)stack) && this.hasPreferredStack(stack) && !ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.getPreferredStack(stack));
    }
}

