/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.inventory.SyncedField;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="computercraft")})
public class TileEntityBase
extends TileEntity
implements IGUIButtonSensitive,
IDescSynced,
IUpgradeAcceptor,
IPeripheral {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.anySignal", (Object)"gui.tab.redstoneBehaviour.button.highSignal", (Object)"gui.tab.redstoneBehaviour.button.lowSignal");
    private final Set<Item> applicableUpgrades = new HashSet<Item>();
    private final Set<String> applicableCustomUpgrades = new HashSet<String>();
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    UpgradeHandler upgradeHandler;
    boolean firstRun = true;
    int poweredRedstone;
    private boolean descriptionPacketScheduled;
    private List<SyncedField> descriptionFields;
    private TileEntityCache[] tileCache;
    private IBlockState cachedBlockState;
    public boolean preserveUpgradesOnBreak = false;
    private float actualSpeedMult = 1.5f;
    private float actualUsageMult = 1.65f;
    private LuaMethodRegistry luaMethodRegistry = null;

    public TileEntityBase() {
        this(0);
    }

    public TileEntityBase(int upgradeSize) {
        this.upgradeHandler = new UpgradeHandler(upgradeSize);
    }

    private static String makeUpgradeKey(ItemStack stack) {
        return stack.func_77973_b().getRegistryName() + ":" + stack.func_77960_j();
    }

    protected void addApplicableUpgrade(IItemRegistry.EnumUpgrade ... upgrades) {
        for (IItemRegistry.EnumUpgrade upgrade : upgrades) {
            this.addApplicableUpgrade(Itemss.upgrades.get(upgrade));
        }
    }

    protected void addApplicableUpgrade(Item upgrade) {
        this.applicableUpgrades.add(upgrade);
    }

    protected void addApplicableCustomUpgrade(ItemStack ... upgrades) {
        for (ItemStack upgrade : upgrades) {
            this.applicableCustomUpgrades.add(TileEntityBase.makeUpgradeKey(upgrade));
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        return new PacketDescription(this).writeNBT(compound);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        PacketDescription packet = new PacketDescription(tag);
        packet.handleClientSide(packet, PneumaticCraftRepressurized.proxy.getClientPlayer());
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public List<SyncedField> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            for (SyncedField field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    public void sendDescriptionPacket() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        this.sendDescPacket(256.0);
    }

    void scheduleDescriptionPacket() {
        this.descriptionPacketScheduled = true;
    }

    void sendDescPacket(double maxPacketDistance) {
        NetworkHandler.sendToAllAround((IMessage)new PacketDescription(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), maxPacketDistance));
    }

    void updateImpl() {
        if (this.firstRun && !this.field_145850_b.field_72995_K) {
            this.onFirstServerUpdate();
            this.onNeighborTileUpdate();
            this.onNeighborBlockUpdate();
        }
        this.firstRun = false;
        this.upgradeCache.validate();
        if (!this.field_145850_b.field_72995_K) {
            if (this instanceof IHeatExchanger) {
                ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(null).update();
            }
            if (this.descriptionFields == null) {
                this.descriptionPacketScheduled = true;
            }
            for (SyncedField field : this.getDescriptionFields()) {
                if (!field.update()) continue;
                this.descriptionPacketScheduled = true;
            }
            if (this.descriptionPacketScheduled) {
                this.descriptionPacketScheduled = false;
                this.sendDescriptionPacket();
            }
        }
    }

    protected void onFirstServerUpdate() {
        this.initializeIfHeatExchanger();
    }

    protected void updateNeighbours() {
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
    }

    public void onBlockRotated() {
        if (this instanceof ISideConfigurable) {
            for (SideConfigurator sc : ((ISideConfigurable)((Object)this)).getSideConfigurators()) {
                sc.setupFacingMatrix();
            }
        }
    }

    void rerenderTileEntity() {
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return false;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        if (this instanceof ISideConfigurable) {
            NBTTagCompound sides = new NBTTagCompound();
            for (SideConfigurator sc : ((ISideConfigurable)((Object)this)).getSideConfigurators()) {
                sides.func_74782_a(sc.getID(), (NBTBase)sc.serializeNBT());
            }
            tag.func_74782_a("SideConfigurator", (NBTBase)sides);
        }
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        if (this instanceof ISideConfigurable) {
            NBTTagCompound sides = tag.func_74775_l("SideConfigurator");
            for (SideConfigurator sc : ((ISideConfigurable)((Object)this)).getSideConfigurators()) {
                sc.deserializeNBT(sides.func_74775_l(sc.getID()));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.upgradeHandler != null && this.upgradeHandler.getSlots() > 0) {
            tag.func_74782_a("Upgrades", (NBTBase)this.upgradeHandler.serializeNBT());
        }
        this.writeToPacket(tag);
        if (this instanceof IHeatExchanger) {
            ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(null).writeToNBT(tag);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Upgrades") && this.upgradeHandler != null) {
            this.upgradeHandler = new UpgradeHandler(this.upgradeHandler.getSlots());
            this.upgradeHandler.deserializeNBT(tag.func_74775_l("Upgrades"));
            this.upgradeCache.validate();
        }
        this.readFromPacket(tag);
        if (this instanceof IHeatExchanger) {
            ((IHeatExchanger)((Object)this)).getHeatExchangerLogic(null).readFromNBT(tag);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.scheduleDescriptionPacket();
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.rerenderTileEntity();
        }
    }

    public void onGuiUpdate() {
    }

    public EnumFacing getRotation() {
        if (this.cachedBlockState == null) {
            this.cachedBlockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        }
        return (EnumFacing)this.cachedBlockState.func_177229_b(BlockPneumaticCraft.ROTATION);
    }

    public void func_145836_u() {
        this.cachedBlockState = null;
        super.func_145836_u();
    }

    public int getUpgrades(Item upgrade) {
        int upgrades = 0;
        for (int i = 0; i < this.upgradeHandler.getSlots(); ++i) {
            ItemStack stack = this.upgradeHandler.getStackInSlot(i);
            if (stack.func_77973_b() != upgrade) continue;
            upgrades += stack.func_190916_E();
        }
        return upgrades;
    }

    public int getUpgrades(IItemRegistry.EnumUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    protected int getCustomUpgrades(ItemStack upgradeStack) {
        return this.upgradeCache.getUpgrades(upgradeStack);
    }

    public float getSpeedMultiplierFromUpgrades() {
        return this.actualSpeedMult;
    }

    public float getSpeedUsageMultiplierFromUpgrades() {
        return this.actualUsageMult;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
    }

    public boolean isGuiUseableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void onNeighborTileUpdate() {
        this.initializeIfHeatExchanger();
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    public TileEntityCache[] getTileCache() {
        if (this.tileCache == null) {
            this.tileCache = TileEntityCache.getDefaultCache(this.func_145831_w(), this.func_174877_v());
        }
        return this.tileCache;
    }

    TileEntity getCachedNeighbor(EnumFacing dir) {
        return this.getTileCache()[dir.func_176745_a()].getTileEntity();
    }

    public void onNeighborBlockUpdate() {
        this.poweredRedstone = PneumaticCraftUtils.getRedstoneLevel(this.func_145831_w(), this.func_174877_v());
        this.initializeIfHeatExchanger();
        for (TileEntityCache cache : this.getTileCache()) {
            cache.update();
        }
    }

    public boolean redstoneAllows() {
        if (this.func_145831_w().field_72995_K) {
            this.onNeighborBlockUpdate();
        }
        switch (((IRedstoneControl)((Object)this)).getRedstoneMode()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.poweredRedstone > 0;
            }
            case 2: {
                return this.poweredRedstone == 0;
            }
        }
        return false;
    }

    protected void initializeIfHeatExchanger() {
        if (this instanceof IHeatExchanger) {
            this.initializeHeatExchanger(((IHeatExchanger)((Object)this)).getHeatExchangerLogic(null), this.getConnectedHeatExchangerSides());
        }
    }

    void initializeHeatExchanger(IHeatExchangerLogic heatExchanger, EnumFacing ... connectedSides) {
        heatExchanger.initializeAsHull(this.func_145831_w(), this.func_174877_v(), connectedSides);
    }

    protected EnumFacing[] getConnectedHeatExchangerSides() {
        return new EnumFacing[0];
    }

    void autoExportLiquid() {
        IFluidHandler handler;
        FluidStack toDrain;
        if (this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (toDrain = (handler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, false)) != null && toDrain.amount > 0) {
            for (EnumFacing d : EnumFacing.field_82609_l) {
                TileEntity te = this.getTileCache()[d.ordinal()].getTileEntity();
                if (te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d())) continue;
                IFluidHandler destHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d());
                FluidStack sent = FluidUtil.tryFluidTransfer((IFluidHandler)destHandler, (IFluidHandler)handler, (FluidStack)toDrain, (boolean)true);
                toDrain.amount = toDrain.amount - (sent == null ? 0 : sent.amount);
                if (toDrain.amount <= 0) break;
            }
        }
    }

    @Override
    public IDescSynced.Type getSyncType() {
        return IDescSynced.Type.TILE_ENTITY;
    }

    void processFluidItem(int inputSlot, int outputSlot) {
        FluidStack transferred;
        if (!this.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || !this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack fluidContainer = itemHandler.getStackInSlot(inputSlot);
        IFluidHandlerItem fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)fluidContainer);
        if (fluidHandlerItem == null) {
            return;
        }
        if (fluidContainer.func_190916_E() > 1) {
            FluidStack stack = fluidHandlerItem.drain(1, false);
            if (stack != null && stack.amount > 0) {
                return;
            }
            ItemStack itemToFill = fluidContainer.func_77946_l();
            itemToFill.func_190920_e(1);
            fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)fluidContainer);
        }
        IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        FluidStack itemContents = fluidHandlerItem.drain(1000, false);
        if (itemContents != null && itemContents.amount > 0) {
            ItemStack emptyContainerStack;
            ItemStack excess;
            FluidStack transferred2 = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)fluidHandlerItem, (int)itemContents.amount, (boolean)true);
            if (transferred2 != null && transferred2.amount == itemContents.amount && (excess = itemHandler.insertItem(outputSlot, emptyContainerStack = fluidHandlerItem.getContainer(), false)).func_190926_b()) {
                itemHandler.extractItem(inputSlot, 1, false);
            }
        } else if (itemHandler.getStackInSlot(outputSlot).func_190926_b() && (transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true)) != null && transferred.amount > 0) {
            itemHandler.extractItem(inputSlot, 1, false);
            ItemStack filledContainerStack = fluidHandlerItem.getContainer();
            itemHandler.insertItem(outputSlot, filledContainerStack, false);
        }
    }

    public ITextComponent func_145748_c_() {
        return this.getName() == null ? new TextComponentString("???") : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        return this.applicableUpgrades;
    }

    @Override
    public String getName() {
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    protected void addLuaMethods(LuaMethodRegistry registry) {
        if (this instanceof IHeatExchanger) {
            final IHeatExchanger exchanger = (IHeatExchanger)((Object)this);
            registry.registerLuaMethod(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireArgs(args, 0, 1, "face? (down/up/north/south/west/east)");
                    if (args.length == 0) {
                        return new Object[]{exchanger.getHeatExchangerLogic(null).getTemperature()};
                    }
                    IHeatExchangerLogic logic = exchanger.getHeatExchangerLogic(this.getDirForString((String)args[0]));
                    return new Object[]{logic != null ? logic.getTemperature() : 0.0};
                }
            });
        }
    }

    private LuaMethodRegistry getLuaMethodRegistry() {
        if (this.luaMethodRegistry == null) {
            this.luaMethodRegistry = new LuaMethodRegistry();
            this.addLuaMethods(this.luaMethodRegistry);
        }
        return this.luaMethodRegistry;
    }

    public String getType() {
        return this.func_145838_q().func_149739_a().substring(5);
    }

    public String[] getMethodNames() {
        return this.getLuaMethodRegistry().getMethodNames();
    }

    public Object[] callLuaMethod(String methodName, Object ... args) throws Exception {
        return this.getLuaMethodRegistry().getMethod(methodName).call(args);
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        try {
            return this.getLuaMethodRegistry().getMethod(method).call(arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="computercraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="computercraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof TileEntity) {
            TileEntity otherTE = (TileEntity)other;
            return otherTE.func_145831_w().equals(this.func_145831_w()) && otherTE.func_174877_v().equals((Object)this.func_174877_v());
        }
        return false;
    }

    public IItemHandlerModifiable getPrimaryInventory() {
        return null;
    }

    public UpgradeHandler getUpgradesInventory() {
        return this.upgradeHandler;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getPrimaryInventory() != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getPrimaryInventory() != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getPrimaryInventory());
        }
        return (T)super.getCapability(capability, facing);
    }

    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        IBlockState camoState;
        UpgradeHandler upgrades;
        if (this.getPrimaryInventory() != null) {
            for (int i = 0; i < this.getPrimaryInventory().getSlots(); ++i) {
                drops.add((Object)this.getPrimaryInventory().getStackInSlot(i));
            }
        }
        if (!this.preserveUpgradesOnBreak && (upgrades = this.getUpgradesInventory()) != null) {
            for (int i = 0; i < upgrades.getSlots(); ++i) {
                if (upgrades.getStackInSlot(i).func_190926_b()) continue;
                drops.add((Object)upgrades.getStackInSlot(i));
            }
        }
        if (this instanceof ICamouflageableTE && (camoState = ((ICamouflageableTE)((Object)this)).getCamouflage()) != null) {
            drops.add((Object)ICamouflageableTE.getStackForState(camoState));
        }
    }

    public void onTileEntityCreated() {
    }

    public final String getRedstoneButtonText(int mode) {
        try {
            return this.getRedstoneButtonLabels().get(mode);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<ERROR>";
        }
    }

    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public int getRedstoneModeCount() {
        return this.getRedstoneButtonLabels().size();
    }

    public String getRedstoneTabTitle() {
        return this instanceof IRedstoneControlled ? "gui.tab.redstoneBehaviour.enableOn" : "gui.tab.redstoneBehaviour.emitRedstoneWhen";
    }

    protected void onUpgradesChanged() {
        this.actualSpeedMult = (float)Math.pow(ConfigHandler.machineProperties.speedUpgradeSpeedMultiplier, Math.min(10, this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED)));
        this.actualUsageMult = (float)Math.pow(ConfigHandler.machineProperties.speedUpgradeUsageMultiplier, Math.min(10, this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED)));
    }

    public UpgradeCache getUpgradeCache() {
        return this.upgradeCache;
    }

    public class UpgradeCache {
        private final int[] upgradeCount = new int[IItemRegistry.EnumUpgrade.values().length];
        private Map<String, Integer> customUpgradeCount;
        private final TileEntityBase te;
        private boolean isValid = false;

        UpgradeCache(TileEntityBase te) {
            this.te = te;
        }

        void validate() {
            if (this.isValid) {
                return;
            }
            Arrays.fill(this.upgradeCount, 0);
            this.customUpgradeCount = null;
            UpgradeHandler inv = this.te.getUpgradesInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_77973_b() instanceof ItemMachineUpgrade) {
                    int idx;
                    int n = idx = ((ItemMachineUpgrade)stack.func_77973_b()).getUpgradeType().ordinal();
                    this.upgradeCount[n] = this.upgradeCount[n] + inv.getStackInSlot(i).func_190916_E();
                    continue;
                }
                if (inv.getStackInSlot(i).func_190926_b()) continue;
                if (this.customUpgradeCount == null) {
                    this.customUpgradeCount = Maps.newHashMap();
                }
                String key = TileEntityBase.makeUpgradeKey(stack);
                this.customUpgradeCount.put(key, this.customUpgradeCount.getOrDefault(key, 0) + stack.func_190916_E());
            }
            this.te.onUpgradesChanged();
            this.isValid = true;
        }

        public void invalidate() {
            this.isValid = false;
        }

        public int getUpgrades(IItemRegistry.EnumUpgrade type) {
            return this.upgradeCount[type.ordinal()];
        }

        public int getUpgrades(ItemStack stack) {
            return this.customUpgradeCount == null ? 0 : this.customUpgradeCount.getOrDefault(TileEntityBase.makeUpgradeKey(stack), 0);
        }
    }

    public class UpgradeHandler
    extends FilteredItemStackHandler {
        UpgradeHandler(int upgradeSize) {
            super(TileEntityBase.this, upgradeSize);
        }

        @Override
        public boolean test(Integer integer, ItemStack itemStack) {
            return itemStack.func_190926_b() || TileEntityBase.this.applicableUpgrades.contains(itemStack.func_77973_b()) || TileEntityBase.this.applicableCustomUpgrades.contains(TileEntityBase.makeUpgradeKey(itemStack));
        }

        @Override
        protected void onContentsChanged(int slot) {
            TileEntityBase.this.upgradeCache.invalidate();
        }
    }
}

