/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.config.ConfigHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidTank;

public interface ISmartFluidSync {
    public void updateScaledFluidAmount(int var1, int var2);

    public static class SmartSyncTank
    extends FluidTank {
        private final ISmartFluidSync holder;
        private final int tankIndex;
        private final double scaleValue;

        SmartSyncTank(ISmartFluidSync holder, int capacity, int tankIndex) {
            super(capacity);
            this.holder = holder;
            this.tankIndex = tankIndex;
            this.scaleValue = (double)this.getCapacity() * ConfigHandler.advanced.liquidTankUpdateThreshold;
        }

        SmartSyncTank(ISmartFluidSync holder, int capacity) {
            this(holder, capacity, 1);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            this.holder.updateScaledFluidAmount(this.tankIndex, this.getScaledFluidAmount());
            if (this.holder instanceof TileEntity) {
                ((TileEntity)this.holder).func_70296_d();
            }
        }

        int getScaledFluidAmount() {
            return (int)((double)this.getFluidAmount() / this.scaleValue);
        }
    }
}

