/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import me.desht.pneumaticcraft.common.block.tubes.IPneumaticPosProvider;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.thirdparty.ModInteractionUtilImplementation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModInteractionUtils {
    private static final ModInteractionUtils INSTANCE = new ModInteractionUtilImplementation();
    @GameRegistry.ObjectHolder(value="thermalfoundation:wrench")
    private static final Item CRESCENT_HAMMER = null;
    @GameRegistry.ObjectHolder(value="rftools:smartwrench")
    private static final Item SMART_WRENCH = null;
    @GameRegistry.ObjectHolder(value="immersiveengineering:tool")
    private static final Item IMMERSIVE_TOOL = null;
    @GameRegistry.ObjectHolder(value="appliedenergistics2:certus_quartz_wrench")
    private static final Item AE2_CERTUS_WRENCH = null;
    @GameRegistry.ObjectHolder(value="appliedenergistics2:nether_quartz_wrench")
    private static final Item AE2_NETHER_WRENCH = null;
    @GameRegistry.ObjectHolder(value="enderio:item_yeta_wrench")
    private static final Item YETA_WRENCH = null;
    @GameRegistry.ObjectHolder(value="buildcraftcore:wrench")
    private static final Item BC_WRENCH = null;
    @GameRegistry.ObjectHolder(value="teslacorelib:wrench")
    private static final Item TESLA_WRENCH = null;
    @GameRegistry.ObjectHolder(value="ic2:wrench")
    private static final Item IC2_WRENCH = null;
    @GameRegistry.ObjectHolder(value="chiselsandbits:wrench_wood")
    private static final Item CB_WRENCH_WOOD = null;
    private static final Set<String> wrenches = new HashSet<String>();

    public static ModInteractionUtils getInstance() {
        return INSTANCE;
    }

    public static void registerThirdPartyWrenches() {
        ModInteractionUtils.registerWrench(CRESCENT_HAMMER);
        ModInteractionUtils.registerWrench(SMART_WRENCH);
        ModInteractionUtils.registerWrench(IMMERSIVE_TOOL);
        ModInteractionUtils.registerWrench(AE2_CERTUS_WRENCH);
        ModInteractionUtils.registerWrench(AE2_NETHER_WRENCH);
        ModInteractionUtils.registerWrench(YETA_WRENCH);
        ModInteractionUtils.registerWrench(BC_WRENCH);
        ModInteractionUtils.registerWrench(TESLA_WRENCH);
        ModInteractionUtils.registerWrench(IC2_WRENCH);
        ModInteractionUtils.registerWrench(CB_WRENCH_WOOD);
    }

    private static void registerWrench(Item wrench) {
        if (wrench != null) {
            wrenches.add(ModInteractionUtils.makeWrenchKey(new ItemStack(wrench)));
        }
    }

    private static String makeWrenchKey(ItemStack wrench) {
        return wrench.func_77973_b().getRegistryName() + (ModInteractionUtils.getWrenchMeta(wrench) >= 0 ? ":" + wrench.func_77960_j() : "");
    }

    private static int getWrenchMeta(ItemStack wrench) {
        if (wrench.func_77973_b() == IMMERSIVE_TOOL) {
            return 0;
        }
        return -1;
    }

    public boolean isModdedWrench(@Nonnull ItemStack stack) {
        return wrenches.contains(ModInteractionUtils.makeWrenchKey(stack));
    }

    public IPneumaticMachine getMachine(TileEntity te) {
        return te instanceof IPneumaticMachine ? (IPneumaticMachine)te : null;
    }

    public IPneumaticWrenchable getWrenchable(TileEntity te) {
        return null;
    }

    public Item getModuleItem(String moduleName) {
        return new ItemTubeModule(moduleName);
    }

    public void registerModulePart(String partName) {
    }

    public boolean isMultipart(TileEntity te) {
        return false;
    }

    public ItemStack exportStackToTEPipe(TileEntity te, ItemStack stack, EnumFacing side) {
        return stack;
    }

    public ItemStack exportStackToBCPipe(TileEntity te, ItemStack stack, EnumFacing side) {
        return stack;
    }

    public boolean isBCPipe(TileEntity te) {
        return false;
    }

    public boolean isTEPipe(TileEntity te) {
        return false;
    }

    public boolean isMultipartWiseConnected(Object part, EnumFacing dir) {
        return false;
    }

    public TileEntityPressureTube getTube(Object potentialTube) {
        return potentialTube instanceof TileEntityPressureTube ? (TileEntityPressureTube)potentialTube : null;
    }

    public void sendDescriptionPacket(IPneumaticPosProvider te) {
        ((TileEntityPressureTube)te).sendDescriptionPacket();
    }

    public void removeTube(TileEntity te) {
        te.func_145831_w().func_175698_g(te.func_174877_v());
    }

    public boolean occlusionTest(AxisAlignedBB aabb, TileEntity te) {
        return true;
    }
}

