/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.remote;

import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.util.math.BlockPos;

public class TextVariableParser {
    private final String orig;
    private final DroneAIManager variableHolder;
    private final Set<String> relevantVariables = new HashSet<String>();

    public TextVariableParser(String str) {
        this(str, null);
    }

    public TextVariableParser(String str, DroneAIManager variableHolder) {
        this.orig = str;
        this.variableHolder = variableHolder;
    }

    public String parse() {
        int index;
        String ret = this.orig;
        while ((index = ret.indexOf("${")) >= 0) {
            int secondIndex = ret.indexOf("}", index);
            if (secondIndex >= 0) {
                String varValue = this.getVariableValue(ret.substring(index + 2, secondIndex));
                ret = ret.substring(0, index) + varValue + ret.substring(secondIndex + 1);
                continue;
            }
            return ret.substring(0, index) + "Parsing error: Missing '}'";
        }
        return ret;
    }

    public Set<String> getRelevantVariables() {
        return this.relevantVariables;
    }

    private String getVariableValue(String variable) {
        BlockPos pos;
        boolean x = variable.endsWith(".x");
        boolean y = variable.endsWith(".y");
        boolean z = variable.endsWith(".z");
        if (x || y || z) {
            variable = variable.substring(0, variable.length() - 2);
        }
        this.relevantVariables.add(variable);
        BlockPos blockPos = this.variableHolder != null ? this.variableHolder.getCoordinate(variable) : (pos = GlobalVariableManager.getInstance().getPos(variable.startsWith("#") ? variable.substring(1) : variable));
        if (x) {
            return pos.func_177958_n() + "";
        }
        if (y) {
            return pos.func_177956_o() + "";
        }
        if (z) {
            return pos.func_177952_p() + "";
        }
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }
}

