/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class BasicThermopneumaticProcessingPlantRecipe
implements IThermopneumaticProcessingPlantRecipe {
    public static final List<IThermopneumaticProcessingPlantRecipe> recipes = new ArrayList<IThermopneumaticProcessingPlantRecipe>();
    private final FluidStack inputLiquid;
    private final FluidStack outputLiquid;
    private final ItemStack inputItem;
    private final float requiredPressure;
    private final double requiredTemperature;

    public BasicThermopneumaticProcessingPlantRecipe(FluidStack inputLiquid, @Nonnull ItemStack inputItem, FluidStack outputLiquid, double requiredTemperature, float requiredPressure) {
        this.inputItem = inputItem;
        this.inputLiquid = inputLiquid;
        this.outputLiquid = outputLiquid;
        this.requiredTemperature = requiredTemperature;
        this.requiredPressure = requiredPressure;
    }

    @Override
    public boolean isValidRecipe(FluidStack fluidStack, @Nonnull ItemStack inputItem) {
        if (this.inputLiquid != null) {
            if (fluidStack == null) {
                return false;
            }
            if (!Fluids.areFluidsEqual(fluidStack.getFluid(), this.inputLiquid.getFluid())) {
                return false;
            }
            if (fluidStack.amount < this.inputLiquid.amount) {
                return false;
            }
        }
        if (!this.inputItem.func_190926_b()) {
            if (inputItem.func_190926_b()) {
                return false;
            }
            if (!inputItem.func_77969_a(this.inputItem) && !PneumaticCraftUtils.isSameOreDictStack(inputItem, this.inputItem)) {
                return false;
            }
            return inputItem.func_190916_E() >= this.inputItem.func_190916_E();
        }
        return true;
    }

    @Override
    public boolean isValidInput(FluidStack inputFluid) {
        return this.inputLiquid != null && Fluids.areFluidsEqual(inputFluid.getFluid(), this.inputLiquid.getFluid());
    }

    @Override
    public boolean isValidInput(ItemStack inputItem) {
        return !this.inputItem.func_190926_b() && inputItem.func_77969_a(this.inputItem) || PneumaticCraftUtils.isSameOreDictStack(inputItem, this.inputItem);
    }

    @Override
    public FluidStack getRecipeOutput(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        return this.outputLiquid;
    }

    @Override
    public void useRecipeItems(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        if (this.inputLiquid != null) {
            inputTank.amount -= this.inputLiquid.amount;
        }
        if (!this.inputItem.func_190926_b()) {
            inputItem.func_190918_g(this.inputItem.func_190916_E());
        }
    }

    @Override
    public void useResources(IFluidHandler fluidHandler, IItemHandler itemHandler) {
        fluidHandler.drain(this.inputLiquid.amount, true);
        itemHandler.extractItem(0, this.inputItem.func_190916_E(), false);
    }

    @Override
    public double getRequiredTemperature(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        return this.requiredTemperature;
    }

    @Override
    public float getRequiredPressure(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        return this.requiredPressure;
    }

    @Override
    public double heatUsed(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        return (this.requiredTemperature - 295.0) / 10.0;
    }

    @Override
    public int airUsed(FluidStack inputTank, @Nonnull ItemStack inputItem) {
        return (int)(this.requiredPressure * 50.0f);
    }

    public FluidStack getInputLiquid() {
        return this.inputLiquid;
    }

    public FluidStack getOutputLiquid() {
        return this.outputLiquid;
    }

    @Nonnull
    public ItemStack getInputItem() {
        return this.inputItem;
    }
}

