/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;

public class PacketToggleArmorFeature
extends AbstractPacket<PacketToggleArmorFeature> {
    private byte featureIndex;
    private boolean state;
    private EntityEquipmentSlot slot;

    public PacketToggleArmorFeature() {
    }

    public PacketToggleArmorFeature(byte featureIndex, boolean state, EntityEquipmentSlot slot) {
        this.featureIndex = featureIndex;
        this.state = state;
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.featureIndex = buf.readByte();
        this.state = buf.readBoolean();
        this.slot = EntityEquipmentSlot.values()[buf.readByte()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.featureIndex);
        buf.writeBoolean(this.state);
        buf.writeByte(this.slot.ordinal());
    }

    @Override
    public void handleClientSide(PacketToggleArmorFeature message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketToggleArmorFeature message, EntityPlayer player) {
        if (message.featureIndex >= 0 && message.featureIndex < UpgradeRenderHandlerList.instance().getHandlersForSlot(message.slot).size()) {
            CommonHUDHandler.getHandlerForPlayer(player).setUpgradeRenderEnabled(message.slot, message.featureIndex, message.state);
        }
    }
}

