/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.inventory.SyncedField;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketDescription
extends LocationIntPacket<PacketDescription> {
    private byte[] types;
    private Object[] values;
    private NBTTagCompound extraData;
    private IDescSynced.Type type;

    public PacketDescription() {
    }

    public PacketDescription(IDescSynced te) {
        super(te.getPosition());
        this.type = te.getSyncType();
        this.values = new Object[te.getDescriptionFields().size()];
        this.types = new byte[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = te.getDescriptionFields().get(i).getValue();
            this.types[i] = PacketUpdateGui.getType(te.getDescriptionFields().get(i));
        }
        this.extraData = new NBTTagCompound();
        te.writeToPacket(this.extraData);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            buf.writeByte((int)this.types[i]);
            PacketUpdateGui.writeField(buf, this.values[i], this.types[i]);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.extraData);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.type = IDescSynced.Type.values()[buf.readByte()];
        int dataAmount = buf.readInt();
        this.types = new byte[dataAmount];
        this.values = new Object[dataAmount];
        for (int i = 0; i < dataAmount; ++i) {
            this.types[i] = buf.readByte();
            this.values[i] = PacketUpdateGui.readField(buf, this.types[i]);
        }
        this.extraData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static Object getSyncableForType(PacketDescription message, EntityPlayer player, IDescSynced.Type type) {
        switch (type) {
            case TILE_ENTITY: {
                return message.getTileEntity(player.field_70170_p);
            }
            case SEMI_BLOCK: {
                if (message.pos.equals((Object)new BlockPos(0, 0, 0))) {
                    Container container = player.field_71070_bA;
                    if (!(container instanceof ContainerLogistics)) break;
                    return ((ContainerLogistics)container).logistics;
                }
                List<ISemiBlock> semiBlocks = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlocksAsList(player.field_70170_p, message.pos);
                byte index = message.extraData.func_74771_c("index");
                return index < semiBlocks.size() ? semiBlocks.get(index) : null;
            }
        }
        return null;
    }

    @Override
    public void handleClientSide(PacketDescription message, EntityPlayer player) {
        Object syncable;
        if (player.field_70170_p.func_175667_e(message.pos) && (syncable = PacketDescription.getSyncableForType(message, player, message.type)) instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)syncable;
            List<SyncedField> descFields = descSynced.getDescriptionFields();
            if (descFields != null && descFields.size() == message.types.length) {
                for (int i = 0; i < descFields.size(); ++i) {
                    descFields.get(i).setValue(message.values[i]);
                }
            }
            descSynced.readFromPacket(message.extraData);
            descSynced.onDescUpdate();
        }
    }

    @Override
    public void handleServerSide(PacketDescription message, EntityPlayer player) {
    }

    public NBTTagCompound writeNBT(NBTTagCompound compound) {
        compound.func_74782_a("Pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74768_a("SyncType", this.type.ordinal());
        compound.func_74768_a("Length", this.values.length);
        ByteBuf buf = Unpooled.buffer();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.types.length; ++i) {
            NBTTagCompound element = new NBTTagCompound();
            element.func_74774_a("Type", this.types[i]);
            buf.clear();
            PacketUpdateGui.writeField(buf, this.values[i], this.types[i]);
            element.func_74773_a("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
            list.func_74742_a((NBTBase)element);
        }
        buf.release();
        compound.func_74782_a("Data", (NBTBase)list);
        compound.func_74782_a("Extra", (NBTBase)this.extraData);
        return compound;
    }

    public PacketDescription(NBTTagCompound compound) {
        super(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("Pos")));
        this.type = IDescSynced.Type.values()[compound.func_74762_e("SyncType")];
        this.values = new Object[compound.func_74762_e("Length")];
        this.types = new byte[this.values.length];
        NBTTagList list = compound.func_150295_c("Data", 10);
        for (int i = 0; i < this.values.length; ++i) {
            NBTTagCompound element = list.func_150305_b(i);
            this.types[i] = element.func_74771_c("Type");
            byte[] b = element.func_74770_j("Value");
            this.values[i] = PacketUpdateGui.readField(Unpooled.wrappedBuffer((byte[])b), this.types[i]);
        }
        this.extraData = compound.func_74775_l("Extra");
    }
}

