/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketNotifyVariablesRemote;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;

public class ItemRemote
extends ItemPneumatic {
    public ItemRemote() {
        super("remote");
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (handIn != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            this.openGui(player, stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        ItemStack remote = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K && !player.func_70093_af() && this.isAllowedToEdit(player, remote) && (te = world.func_175625_s(pos)) instanceof TileEntitySecurityStation) {
            if (((TileEntitySecurityStation)te).doesAllowPlayer(player)) {
                NBTTagCompound tag = remote.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    remote.func_77982_d(tag);
                }
                tag.func_74768_a("securityX", pos.func_177958_n());
                tag.func_74768_a("securityY", pos.func_177956_o());
                tag.func_74768_a("securityZ", pos.func_177952_p());
                tag.func_74768_a("securityDimension", world.field_73011_w.getDimension());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.remote.boundSecurityStation", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), false);
                return EnumActionResult.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.remote.cantBindSecurityStation", new Object[0]), false);
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack remote, World world, List<String> curInfo, ITooltipFlag moreInfo) {
        super.func_77624_a(remote, world, curInfo, moreInfo);
        curInfo.add(I18n.func_135052_a((String)"gui.remote.tooltip.sneakRightClickToEdit", (Object[])new Object[0]));
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null && tag.func_74764_b("securityX")) {
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            Collections.addAll(curInfo, WordUtils.wrap((String)I18n.func_135052_a((String)"gui.remote.tooltip.boundToSecurityStation", (Object[])new Object[]{dimensionId, x, y, z}), (int)40).split(System.getProperty("line.separator")));
        } else {
            Collections.addAll(curInfo, WordUtils.wrap((String)I18n.func_135052_a((String)"gui.remote.tooltip.rightClickToBind", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator")));
        }
    }

    private void openGui(EntityPlayer player, ItemStack remote) {
        if (player.func_70093_af()) {
            if (this.isAllowedToEdit(player, remote)) {
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.REMOTE_EDITOR.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                NetworkHandler.sendTo(new PacketNotifyVariablesRemote(GlobalVariableManager.getInstance().getAllActiveVariableNames()), (EntityPlayerMP)player);
            }
        } else {
            player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.REMOTE.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public static boolean hasSameSecuritySettings(ItemStack remote1, ItemStack remote2) {
        NBTTagCompound tag1 = remote1.func_77978_p();
        NBTTagCompound tag2 = remote2.func_77978_p();
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        int x1 = tag1.func_74762_e("securityX");
        int y1 = tag1.func_74762_e("securityY");
        int z1 = tag1.func_74762_e("securityZ");
        int dimension1 = tag1.func_74762_e("securityDimension");
        int x2 = tag2.func_74762_e("securityX");
        int y2 = tag2.func_74762_e("securityY");
        int z2 = tag2.func_74762_e("securityZ");
        int dimension2 = tag2.func_74762_e("securityDimension");
        return x1 == x2 && y1 == y2 && z1 == z2 && dimension1 == dimension2;
    }

    private boolean isAllowedToEdit(EntityPlayer player, ItemStack remote) {
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null && tag.func_74764_b("securityX")) {
            TileEntity te;
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            WorldServer world = DimensionManager.getWorld((int)dimensionId);
            if (world != null && (te = world.func_175625_s(new BlockPos(x, y, z))) instanceof TileEntitySecurityStation) {
                boolean canAccess = ((TileEntitySecurityStation)te).doesAllowPlayer(player);
                if (!canAccess) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("gui.remote.noEditRights", new Object[]{x, y, z}), false);
                }
                return canAccess;
            }
        }
        return true;
    }

    public void func_77663_a(ItemStack remote, World worl, Entity entity, int slot, boolean holdingItem) {
        NBTTagCompound tag;
        if (!worl.field_72995_K && (tag = remote.func_77978_p()) != null && tag.func_74764_b("securityX")) {
            TileEntity te;
            int x = tag.func_74762_e("securityX");
            int y = tag.func_74762_e("securityY");
            int z = tag.func_74762_e("securityZ");
            int dimensionId = tag.func_74762_e("securityDimension");
            WorldServer world = DimensionManager.getWorld((int)dimensionId);
            if (world != null && !((te = world.func_175625_s(new BlockPos(x, y, z))) instanceof TileEntitySecurityStation)) {
                tag.func_82580_o("securityX");
                tag.func_82580_o("securityY");
                tag.func_82580_o("securityZ");
                tag.func_82580_o("securityDimension");
            }
        }
    }
}

