/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemLogisticsFrame
extends ItemSemiBlockBase {
    public ItemLogisticsFrame(String registryName) {
        super(registryName);
        this.func_77637_a(PneumaticCraftRepressurized.tabPneumaticCraft);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (handIn != EnumHand.MAIN_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, this.getSemiBlock(world, null, stack).getGuiID().ordinal(), world, 0, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        ItemLogisticsFrame.addTooltip(stack, worldIn, curInfo, PneumaticCraftRepressurized.proxy.isSneakingInGui());
    }

    public static void addTooltip(ItemStack stack, World world, List<String> curInfo, boolean sneaking) {
        if (stack.func_77978_p() != null && stack.func_77973_b() instanceof ItemSemiBlockBase) {
            SemiBlockLogistics logistics = ContainerLogistics.getLogistics(PneumaticCraftRepressurized.proxy.getClientPlayer(), stack);
            if (logistics == null) {
                return;
            }
            if (logistics.isInvisible()) {
                curInfo.add("- " + I18n.func_135052_a((String)"gui.logistic_frame.invisible", (Object[])new Object[0]));
            }
            String key = SemiBlockManager.getKeyForSemiBlock(SemiBlockManager.getSemiBlockForItem((ItemSemiBlockBase)stack.func_77973_b()));
            if (sneaking) {
                if (logistics.isFuzzyMeta()) {
                    curInfo.add("- " + I18n.func_135052_a((String)"gui.logistic_frame.fuzzyMeta", (Object[])new Object[0]));
                }
                if (logistics.isFuzzyNBT()) {
                    curInfo.add("- " + I18n.func_135052_a((String)"gui.logistic_frame.fuzzyNBT", (Object[])new Object[0]));
                }
                ItemStack[] stacks = new ItemStack[logistics.getFilters().getSlots()];
                for (int i = 0; i < logistics.getFilters().getSlots(); ++i) {
                    stacks[i] = logistics.getFilters().getStackInSlot(i);
                }
                curInfo.add(TextFormatting.WHITE + I18n.func_135052_a((String)("gui.logistic_frame." + (logistics.isWhitelist() ? "whitelist" : "blacklist")), (Object[])new Object[0]) + ":");
                int l = curInfo.size();
                PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, stacks);
                if (curInfo.size() == l) {
                    curInfo.add(I18n.func_135052_a((String)"gui.logistic_frame.no_items", (Object[])new Object[0]));
                }
                l = curInfo.size();
                for (int i = 0; i < 9; ++i) {
                    FluidStack fluid = logistics.getTankFilter(i).getFluid();
                    if (fluid == null) continue;
                    curInfo.add("\u2022 " + fluid.amount + "mB " + fluid.getLocalizedName());
                }
                if (curInfo.size() == l) {
                    curInfo.add(I18n.func_135052_a((String)"gui.logistic_frame.no_fluids", (Object[])new Object[0]));
                }
            } else {
                curInfo.add(I18n.func_135052_a((String)String.format("gui.%s.hasFilters", key), (Object[])new Object[0]));
            }
        }
    }
}

