/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;

public class ChargeableItemHandler
extends FilteredItemStackHandler {
    private static final int INVENTORY_SIZE = 9;
    public static final String NBT_UPGRADE_TAG = "UpgradeInventory";

    public ChargeableItemHandler(TileEntityChargingStation te) {
        super(te, 9);
        if (!NBTUtil.hasTag(this.getChargingStack(), NBT_UPGRADE_TAG)) {
            this.writeToNBT();
        }
        this.readFromNBT();
    }

    @Override
    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.writeToNBT();
    }

    private ItemStack getChargingStack() {
        return ((TileEntityChargingStation)this.te).getChargingItem();
    }

    public void writeToNBT() {
        NBTUtil.setCompoundTag(this.getChargingStack(), NBT_UPGRADE_TAG, (NBTBase)this.serializeNBT());
    }

    private void readFromNBT() {
        this.deserializeNBT(NBTUtil.getCompoundTag(this.getChargingStack(), NBT_UPGRADE_TAG));
    }

    @Override
    public boolean test(Integer integer, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return true;
        }
        if (this.getChargingStack().func_77973_b() instanceof IUpgradeAcceptor) {
            return ((IUpgradeAcceptor)this.getChargingStack().func_77973_b()).getApplicableUpgrades().contains(itemStack.func_77973_b());
        }
        return false;
    }
}

