/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.harvesting.IHarvestHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class HarvestHandlerAbstractCrop
implements IHarvestHandler {
    private final Predicate<IBlockState> blockChecker;

    public HarvestHandlerAbstractCrop(Predicate<IBlockState> blockChecker) {
        this.blockChecker = blockChecker;
    }

    @Override
    public boolean canHarvest(World world, IBlockAccess chunkCache, BlockPos pos, IBlockState state, IDrone drone) {
        return this.blockChecker.test(state) && this.isMaxAge(state);
    }

    @Override
    public boolean harvestAndReplant(World world, IBlockAccess chunkCache, BlockPos pos, IBlockState state, IDrone drone) {
        this.harvest(world, chunkCache, pos, state, drone);
        List seedItems = world.func_175647_a(EntityItem.class, new AxisAlignedBB(pos), entityItem -> this.isSeed(world, pos, state, entityItem.func_92059_d()));
        if (!seedItems.isEmpty()) {
            ((EntityItem)seedItems.get(0)).func_92059_d().func_190918_g(1);
            world.func_175656_a(pos, this.withMinAge(state));
            return true;
        }
        return false;
    }

    protected abstract boolean isSeed(World var1, BlockPos var2, IBlockState var3, ItemStack var4);

    protected abstract boolean isMaxAge(IBlockState var1);

    protected abstract IBlockState withMinAge(IBlockState var1);
}

