/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.block.BlockFluidEtchingAcid;
import me.desht.pneumaticcraft.common.block.BlockFluidPneumaticCraft;
import me.desht.pneumaticcraft.common.fluid.FluidPneumaticCraft;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Fluids {
    public static final Set<Fluid> FLUIDS = new HashSet<Fluid>();
    public static final Set<IFluidBlock> MOD_FLUID_BLOCKS = new HashSet<IFluidBlock>();
    public static final Fluid ETCHING_ACID = Fluids.createFluid("etchacid", fluid -> ((FluidPneumaticCraft)((Object)fluid)).setCustomColor(-6267904), BlockFluidEtchingAcid::new);
    public static final Fluid PLASTIC = Fluids.createFluid("plastic", fluid -> {}, fluid -> new BlockFluidPneumaticCraft((Fluid)fluid, (Material)new MaterialLiquid(MapColor.field_151670_w)));
    public static final Fluid OIL = Fluids.createFluid("oil", fluid -> fluid.setDensity(800).setViscosity(10000), BlockFluidPneumaticCraft::new);
    public static final Fluid LPG = Fluids.createFluid("lpg", fluid -> {}, BlockFluidPneumaticCraft::new);
    public static final Fluid GASOLINE = Fluids.createFluid("fuel", fluid -> {}, BlockFluidPneumaticCraft::new);
    public static final Fluid KEROSENE = Fluids.createFluid("kerosene", fluid -> {}, BlockFluidPneumaticCraft::new);
    public static final Fluid DIESEL = Fluids.createFluid("diesel", fluid -> {}, BlockFluidPneumaticCraft::new);
    public static final Fluid LUBRICANT = Fluids.createFluid("lubricant", fluid -> {}, BlockFluidPneumaticCraft::new);
    private static final Map<String, Block> fluidToBlockMap = new HashMap<String, Block>();

    public static void preInit() {
        Fluids.registerFluidContainers();
        PneumaticRegistry.getInstance().registerFuel(OIL, 64000);
        PneumaticRegistry.getInstance().registerFuel(DIESEL, 700000);
        PneumaticRegistry.getInstance().registerFuel(KEROSENE, 1100000);
        PneumaticRegistry.getInstance().registerFuel(GASOLINE, 1500000);
        PneumaticRegistry.getInstance().registerFuel(LPG, 1800000);
    }

    public static void init() {
        PneumaticCraftAPIHandler.getInstance().registerRefineryInput(OIL);
    }

    private static <T extends Block> Fluid createFluid(String name, Consumer<Fluid> fluidPropertyApplier, Function<Fluid, T> blockFactory) {
        try {
            Fluid fluid;
            Fluid preExistingFluid = FluidRegistry.getFluid((String)name);
            if (preExistingFluid != null) {
                fluid = preExistingFluid;
                Log.warning("Fluid '" + name + "' already registered by another mod: [" + FluidRegistry.getDefaultFluidName((Fluid)fluid) + "] - we'll use it, but it might not be available in block form!");
            } else {
                fluid = new FluidPneumaticCraft(name);
                FluidRegistry.registerFluid((Fluid)fluid);
                fluidPropertyApplier.accept(fluid);
                MOD_FLUID_BLOCKS.add((IFluidBlock)blockFactory.apply(fluid));
            }
            FLUIDS.add(fluid);
            return fluid;
        }
        catch (Exception e) {
            PneumaticCraftRepressurized.logger.error(e.getMessage());
            return null;
        }
    }

    public static boolean areFluidsEqual(Fluid fluid1, Fluid fluid2) {
        return fluid1 == null && fluid2 == null || fluid1 == null == (fluid2 == null) && fluid1.getName().equals(fluid2.getName());
    }

    public static Item getBucket(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)).func_77973_b();
    }

    public static ItemStack getBucketStack(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static Block getBlock(Fluid fluid) {
        return fluidToBlockMap.get(fluid.getName());
    }

    private static void registerFluidContainers() {
        for (Fluid fluid : FLUIDS) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            for (IFluidBlock fluidBlock : MOD_FLUID_BLOCKS) {
                Block block = (Block)fluidBlock;
                block.setRegistryName(PneumaticCraftUtils.RL("fluid." + fluidBlock.getFluid().getName()));
                block.func_149663_c(fluidBlock.getFluid().getName());
                block.func_149647_a((CreativeTabs)PneumaticCraftRepressurized.tabPneumaticCraft);
                registry.register((IForgeRegistryEntry)block);
                fluidToBlockMap.put(fluidBlock.getFluid().getName(), block);
                Log.info("registered block for fluid: " + fluidBlock.getFluid().getName());
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (IFluidBlock fluidBlock : MOD_FLUID_BLOCKS) {
                Block block = (Block)fluidBlock;
                ItemBlock itemBlock = new ItemBlock(block);
                itemBlock.setRegistryName(block.getRegistryName());
                registry.register((IForgeRegistryEntry)itemBlock);
            }
        }
    }
}

