/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import java.util.Comparator;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityMicromissile
extends EntityThrowable {
    private static final double SEEK_RANGE = 24.0;
    private static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(EntityMicromissile.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> MAX_VEL_SQ = EntityDataManager.func_187226_a(EntityMicromissile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ACCEL = EntityDataManager.func_187226_a(EntityMicromissile.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> TURN_SPEED = EntityDataManager.func_187226_a(EntityMicromissile.class, (DataSerializer)DataSerializers.field_187193_c);
    private Entity targetEntity = null;
    private float maxVelocitySq = 0.5f;
    private float accel = 1.05f;
    private float turnSpeed = 0.1f;
    private float explosionPower = 2.0f;
    private EntityFilter entityFilter;
    private boolean outOfFuel = false;
    private ItemMicromissiles.FireMode fireMode = ItemMicromissiles.FireMode.SMART;

    public EntityMicromissile(World worldIn) {
        super(worldIn);
    }

    public EntityMicromissile(World worldIn, EntityLivingBase thrower, ItemStack iStack) {
        super(worldIn, thrower);
        if (iStack.func_77942_o()) {
            NBTTagCompound tag = iStack.func_77978_p();
            this.entityFilter = EntityFilter.fromString(tag.func_74779_i("filter"));
            this.fireMode = ItemMicromissiles.FireMode.fromString(tag.func_74779_i("fireMode"));
            switch (this.fireMode) {
                case SMART: {
                    this.accel = Math.max(1.02f, 1.0f + tag.func_74760_g("topSpeed") / 10.0f);
                    this.maxVelocitySq = (float)Math.pow(0.25 + (double)(tag.func_74760_g("topSpeed") * 3.75f), 2.0);
                    this.turnSpeed = 0.4f * tag.func_74760_g("turnSpeed");
                    this.explosionPower = Math.max(1.0f, 5.0f * tag.func_74760_g("damage"));
                    break;
                }
                case DUMB: {
                    this.accel = 1.02f;
                    this.maxVelocitySq = 2.0f;
                    this.turnSpeed = 0.0f;
                    this.explosionPower = 3.0f;
                }
            }
        }
    }

    public EntityMicromissile(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ID, (Object)0);
        this.field_70180_af.func_187214_a(MAX_VEL_SQ, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(ACCEL, (Object)Float.valueOf(1.05f));
        this.field_70180_af.func_187214_a(TURN_SPEED, (Object)Float.valueOf(0.4f));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.func_130014_f_().field_72995_K) {
            if (key.equals(MAX_VEL_SQ)) {
                this.maxVelocitySq = ((Float)this.field_70180_af.func_187225_a(MAX_VEL_SQ)).floatValue();
            } else if (key.equals(TARGET_ID)) {
                int id = (Integer)this.field_70180_af.func_187225_a(TARGET_ID);
                this.targetEntity = id > 0 ? this.func_130014_f_().func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ID)).intValue()) : null;
            } else if (key.equals(ACCEL)) {
                this.accel = ((Float)this.field_70180_af.func_187225_a(ACCEL)).floatValue();
            } else if (key.equals(TURN_SPEED)) {
                this.turnSpeed = ((Float)this.field_70180_af.func_187225_a(TURN_SPEED)).floatValue();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            if (this.func_130014_f_().field_72995_K) {
                this.func_130014_f_().func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.PLAYERS, 1.0f, 0.8f, true);
            } else {
                this.field_70180_af.func_187227_b(MAX_VEL_SQ, (Object)Float.valueOf(this.maxVelocitySq));
                this.field_70180_af.func_187227_b(ACCEL, (Object)Float.valueOf(this.accel));
                this.field_70180_af.func_187227_b(TURN_SPEED, (Object)Float.valueOf(this.turnSpeed));
            }
        }
        if (this.field_70173_aa > ConfigHandler.microMissile.lifetime) {
            this.outOfFuel = true;
        }
        if (!this.outOfFuel) {
            double velSq;
            if (this.func_70090_H()) {
                this.field_70159_w *= 1.25;
                this.field_70181_x *= 1.25;
                this.field_70179_y *= 1.25;
            } else {
                this.field_70159_w *= 1.0101010101010102;
                this.field_70181_x *= 1.0101010101010102;
                this.field_70179_y *= 1.0101010101010102;
            }
            if ((this.targetEntity == null || this.targetEntity.field_70128_L) && this.fireMode == ItemMicromissiles.FireMode.SMART && !this.func_130014_f_().field_72995_K && (this.field_70173_aa & 3) == 0) {
                this.targetEntity = this.tryFindNewTarget();
            }
            if (this.targetEntity != null) {
                Vec3d diff = this.targetEntity.func_174791_d().func_72441_c(0.0, (double)this.targetEntity.func_70047_e(), 0.0).func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a((double)this.turnSpeed);
                this.field_70159_w += diff.field_72450_a;
                this.field_70181_x += diff.field_72448_b;
                this.field_70179_y += diff.field_72449_c;
            }
            double mul = (velSq = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) > (double)this.maxVelocitySq ? (double)this.maxVelocitySq / velSq : (double)this.accel;
            this.field_70159_w *= mul;
            this.field_70181_x *= mul;
            this.field_70179_y *= mul;
            if (this.func_130014_f_().field_72995_K) {
                PneumaticCraftRepressurized.proxy.playCustomParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.field_70159_w / 2.0, -this.field_70181_x / 2.0, -this.field_70179_y / 2.0);
            }
        }
    }

    private Entity tryFindNewTarget() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_186662_g(24.0);
        List l = this.func_130014_f_().func_175647_a(EntityLivingBase.class, aabb, EntitySelectors.field_94557_a);
        l.sort(new TargetSorter());
        Entity tgt = null;
        for (Entity e : l) {
            RayTraceResult res;
            if (!this.isValidTarget(e) || !(e.func_70068_e((Entity)this) < 576.0) || (res = this.func_130014_f_().func_147447_a(this.func_174791_d(), e.func_174791_d().func_72441_c(0.0, (double)e.func_70047_e(), 0.0), false, false, true)) != null && res.field_72313_a != RayTraceResult.Type.MISS && res.field_72313_a != RayTraceResult.Type.ENTITY) continue;
            tgt = e;
            break;
        }
        this.field_70180_af.func_187227_b(TARGET_ID, (Object)(tgt == null ? 0 : tgt.func_145782_y()));
        return tgt;
    }

    public boolean isValidTarget(Entity e) {
        if (this.field_70192_c != null && (e.equals((Object)this.field_70192_c) || e instanceof EntityTameable && this.field_70192_c.equals((Object)((EntityTameable)e).func_70902_q()) || e instanceof EntityDrone && this.field_70192_c.func_110124_au().toString().equals(((EntityDrone)e).getOwnerUUID()) || e instanceof EntityHorse && this.field_70192_c.func_110124_au().equals(((EntityHorse)e).func_184780_dh()))) {
            return false;
        }
        if (this.entityFilter != null && !this.entityFilter.test(e)) {
            return false;
        }
        return e instanceof EntityLivingBase || e instanceof EntityBoat || e instanceof EntityMinecart;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.field_70173_aa > 5 && !this.func_130014_f_().field_72995_K && !this.field_70128_L) {
            this.explode();
        }
    }

    private void explode() {
        this.func_70106_y();
        this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, ConfigHandler.microMissile.baseExplosionDamage * this.explosionPower, ConfigHandler.microMissile.damageTerrain);
    }

    public void func_184538_a(Entity entityThrower, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(x, y, z, velocity, 0.0f);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        double f = Math.sqrt(x * x + y * y + z * z);
        x = x / f * (double)velocity;
        y = y / f * (double)velocity;
        z = z / f * (double)velocity;
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected float func_70185_h() {
        return this.outOfFuel ? super.func_70185_h() : 0.0f;
    }

    public boolean func_189652_ae() {
        return !this.outOfFuel;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("turnSpeed", this.turnSpeed);
        compound.func_74776_a("explosionScaling", this.explosionPower);
        compound.func_74776_a("topSpeedSq", this.maxVelocitySq);
        compound.func_74778_a("filter", this.entityFilter.toString());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.turnSpeed = compound.func_74760_g("turnSpeed");
        this.explosionPower = compound.func_74760_g("explosionScaling");
        this.maxVelocitySq = compound.func_74760_g("topSpeedSq");
        this.entityFilter = EntityFilter.fromString(compound.func_74779_i("filter"));
    }

    public void setTarget(Entity target) {
        this.targetEntity = target;
    }

    private class TargetSorter
    implements Comparator<Entity> {
        private final Vec3d vec;

        TargetSorter() {
            this.vec = new Vec3d(EntityMicromissile.this.field_70165_t, EntityMicromissile.this.field_70163_u, EntityMicromissile.this.field_70161_v);
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.vec.func_72436_e(e1.func_174791_d()), this.vec.func_72436_e(e2.func_174791_d()));
        }
    }
}

