/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.List;
import me.desht.pneumaticcraft.client.model.module.ModelGauge;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.tubes.TubeModuleRedstoneEmitting;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class ModulePressureGauge
extends TubeModuleRedstoneEmitting {
    public ModulePressureGauge() {
        this.lowerBound = 0.0f;
        this.higherBound = 7.5f;
    }

    @Override
    public void update() {
        super.update();
        if (!this.pressureTube.world().field_72995_K) {
            if (this.pressureTube.world().func_82737_E() % 20L == 0L) {
                NetworkHandler.sendToAllAround(new PacketUpdatePressureBlock((TileEntityPneumaticBase)this.getTube()), this.getTube().world());
            }
            this.setRedstone(this.getRedstone(this.pressureTube.getAirHandler(null).getPressure()));
        }
    }

    private int getRedstone(float pressure) {
        return (int)((pressure - this.lowerBound) / (this.higherBound - this.lowerBound) * 15.0f);
    }

    @Override
    public String getType() {
        return "pressure_gauge_module";
    }

    @Override
    public double getWidth() {
        return 0.5;
    }

    @Override
    protected double getHeight() {
        return 0.25;
    }

    @Override
    public void addItemDescription(List<String> curInfo) {
        curInfo.add(TextFormatting.BLUE + "Formula: Redstone = 2.0 x pressure(bar)");
        curInfo.add("This module emits a redstone signal, the strength of");
        curInfo.add("which depends the tube's pressure.");
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        return super.onActivated(player);
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return GuiHandler.EnumGuiId.PRESSURE_MODULE;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelGauge.class;
    }
}

