/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;

public class BlockChargingStation
extends BlockPneumaticCraftCamo {
    private static final PropertyBool CHARGE_PAD = PropertyBool.func_177716_a((String)"charge_pad");
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125);

    BlockChargingStation() {
        super(Material.field_151573_f, "charging_station");
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{ROTATION, CHARGE_PAD}, UNLISTED_CAMO_PROPERTIES);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(worldIn, pos);
        if (te instanceof TileEntityChargingStation) {
            return state.func_177226_a((IProperty)CHARGE_PAD, (Comparable)Boolean.valueOf(((TileEntityChargingStation)te).dispenserUpgradeInserted));
        }
        return state;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileEntityChargingStation && ((TileEntityChargingStation)te).dispenserUpgradeInserted) {
            return field_185505_j;
        }
        return BOUNDS;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityChargingStation.class;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.CHARGING_STATION;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof TileEntityChargingStation) {
            return ((TileEntityChargingStation)te).shouldEmitRedstone() ? 15 : 0;
        }
        return 0;
    }
}

