/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.semiblock;

import me.desht.pneumaticcraft.client.semiblock.ISemiBlockRenderer;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class SemiBlockRendererLogistics
implements ISemiBlockRenderer<SemiBlockLogistics> {
    private static final double FRAME_WIDTH = 0.03125;
    private static final AxisAlignedBB DEFAULT_BOX = new AxisAlignedBB(0.03125, 0.03125, 0.03125, 0.96875, 0.96875, 0.96875);

    @Override
    public void render(SemiBlockLogistics semiBlock, float partialTick) {
        int alpha = semiBlock.getAlpha();
        if (alpha == 0) {
            return;
        }
        if (alpha < 255) {
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179090_x();
        RenderUtils.glColorHex((alpha << 24 | 0xFFFFFF) & semiBlock.getColor(), this.getLightMultiplier(semiBlock));
        AxisAlignedBB aabb = semiBlock.getWorld() != null ? semiBlock.getBlockState().func_185900_c((IBlockAccess)semiBlock.getWorld(), semiBlock.getPos()) : DEFAULT_BOX;
        RenderUtils.renderFrame(aabb, 0.03125);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private float getLightMultiplier(ISemiBlock semiBlock) {
        return ConfigHandler.client.semiBlockLighting ? (float)Math.max(1, Minecraft.func_71410_x().field_71441_e.func_175699_k(semiBlock.getPos())) / 15.0f : 1.0f;
    }
}

