/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiSearchUpgradeOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderSearchItemBlock;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;

public class SearchUpgradeHandler
implements IUpgradeRenderHandler {
    private int totalSearchedItemCount;
    private int searchedItemCounter;
    private int ticksExisted;
    private final Map<EntityItem, Integer> searchedItems = new HashMap<EntityItem, Integer>();
    private final List<RenderSearchItemBlock> searchedBlocks = new ArrayList<RenderSearchItemBlock>();
    @SideOnly(value=Side.CLIENT)
    private GuiAnimatedStat searchInfo;
    private int statX;
    private int statY;
    private boolean statLeftSided;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "itemSearcher";
    }

    @Override
    public void initConfig() {
        this.statX = ConfigHandler.helmetOptions.itemSearchX;
        this.statY = ConfigHandler.helmetOptions.itemSearchY;
        this.statLeftSided = ConfigHandler.helmetOptions.itemSearchLeft;
    }

    @Override
    public void saveToConfig() {
        ConfigHandler.helmetOptions.itemSearchX = this.statX = this.searchInfo.getBaseX();
        ConfigHandler.helmetOptions.itemSearchY = this.statY = this.searchInfo.getBaseY();
        ConfigHandler.helmetOptions.itemSearchLeft = this.statLeftSided = this.searchInfo.isLeftSided();
        ConfigHandler.sync();
    }

    public void addToSearchedItemCounter(int amount) {
        this.searchedItemCounter += amount;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        ++this.ticksExisted;
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(player.func_184582_a(EntityEquipmentSlot.HEAD));
        if (this.ticksExisted % 20 == 0) {
            List items = player.field_70170_p.func_72872_a(EntityItem.class, EntityTrackUpgradeHandler.getAABBFromRange(player, rangeUpgrades));
            this.searchedItems.clear();
            for (EntityItem item : items) {
                if (item.func_92059_d().func_190926_b() || searchStack.func_190926_b()) continue;
                if (item.func_92059_d().func_77969_a(searchStack)) {
                    this.searchedItems.put(item, item.func_92059_d().func_190916_E());
                    continue;
                }
                List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(item.func_92059_d());
                int itemCount = 0;
                for (ItemStack inventoryItem : inventoryItems) {
                    if (!inventoryItem.func_77969_a(searchStack)) continue;
                    itemCount += inventoryItem.func_190916_E();
                }
                if (itemCount <= 0) continue;
                this.searchedItems.put(item, itemCount);
            }
            this.totalSearchedItemCount = this.searchedItemCounter;
            this.searchedItemCounter = 0;
            for (Integer itemCount : this.searchedItems.values()) {
                this.searchedItemCounter += itemCount.intValue();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(Textures.GLOW_RESOURCE);
        for (Map.Entry<EntityItem, Integer> entry : this.searchedItems.entrySet()) {
            EntityItem item = entry.getKey();
            float height = MathHelper.func_76126_a((float)(((float)item.func_174872_o() + partialTicks) / 10.0f + item.field_70290_d)) * 0.1f + 0.2f;
            RenderSearchItemBlock.renderSearch(item.field_70142_S + (item.field_70165_t - item.field_70142_S) * (double)partialTicks, item.field_70137_T + (item.field_70163_u - item.field_70137_T) * (double)partialTicks + (double)height, item.field_70136_U + (item.field_70161_v - item.field_70136_U) * (double)partialTicks, entry.getValue(), this.totalSearchedItemCount);
        }
        for (int i = 0; i < this.searchedBlocks.size(); ++i) {
            if (this.searchedBlocks.get(i).renderSearchBlock(this.totalSearchedItemCount)) continue;
            this.searchedBlocks.remove(i);
            --i;
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
        ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD));
        ArrayList<String> textList = new ArrayList<String>();
        if (searchStack.func_190926_b()) {
            textList.add("press '" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindOpenOptions.func_151463_i()) + "' to configure");
        } else {
            textList.add(searchStack.func_82833_r() + " (" + this.totalSearchedItemCount + " found)");
        }
        this.searchInfo.setText(textList);
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.SEARCH)};
    }

    public void checkInventoryForItems(TileEntity te, EnumFacing face) {
        try {
            ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD));
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
            assert (handler != null);
            boolean hasFoundItem = false;
            if (!searchStack.func_190926_b()) {
                for (int l = 0; l < handler.getSlots(); ++l) {
                    int items;
                    if (handler.getStackInSlot(l).func_190926_b() || (items = RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchStack)) <= 0) continue;
                    hasFoundItem = true;
                    this.searchedItemCounter += items;
                }
            }
            if (hasFoundItem) {
                boolean inList = false;
                for (RenderSearchItemBlock trackedBlock : this.searchedBlocks) {
                    if (!trackedBlock.isAlreadyTrackingCoord(te.func_174877_v())) continue;
                    inList = true;
                    break;
                }
                if (!inList) {
                    this.searchedBlocks.add(new RenderSearchItemBlock(te.func_145831_w(), te.func_174877_v()));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.searchedBlocks.clear();
        this.searchedItemCounter = 0;
        this.searchedItems.clear();
        this.ticksExisted = 0;
        this.searchInfo = null;
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiSearchUpgradeOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiAnimatedStat getAnimatedStat() {
        if (this.searchInfo == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(minecraft);
            this.searchInfo = new GuiAnimatedStat(null, "Currently searching for:", CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.SEARCH), this.statX != -1 ? this.statX : sr.func_78326_a() - 2, this.statY, 0x3000AA00, null, this.statLeftSided);
            this.searchInfo.setMinDimensionsAndReset(0, 0);
        }
        return this.searchInfo;
    }
}

