/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor.blockTracker;

import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.blockTracker.TrackerBlacklistManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockTrackEntryEnergy
implements IBlockTrackEntry {
    @Override
    public boolean shouldTrackWithThisEntry(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te) {
        if (te == null || TrackerBlacklistManager.isEnergyBlacklisted(te)) {
            return false;
        }
        if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return true;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!te.hasCapability(CapabilityEnergy.ENERGY, face)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeUpdatedFromServer(TileEntity te) {
        return true;
    }

    @Override
    public int spamThreshold() {
        return 8;
    }

    @Override
    public void addInformation(World world, BlockPos pos, TileEntity te, List<String> infoList) {
        try {
            infoList.add("blockTracker.info.rf");
            if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
                infoList.add(storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF");
            }
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addEnergyTEToBlacklist(te, e);
        }
    }

    @Override
    public String getEntryName() {
        return "blockTracker.module.rf";
    }
}

