/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.List;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RenderSearchItemBlock {
    private final BlockPos pos;
    private final World world;

    public RenderSearchItemBlock(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    private int getSearchedItemCount() {
        TileEntity te = this.world.func_175625_s(this.pos);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            int itemCount = 0;
            ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(FMLClientHandler.instance().getClient().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD));
            if (searchStack.func_190926_b()) {
                return 0;
            }
            for (int l = 0; l < handler.getSlots(); ++l) {
                if (handler.getStackInSlot(l).func_190926_b()) continue;
                itemCount += RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchStack);
            }
            return itemCount;
        }
        return 0;
    }

    public static int getSearchedItemCount(ItemStack stack, ItemStack searchStack) {
        int itemCount = 0;
        if (stack.func_77969_a(searchStack)) {
            itemCount += stack.func_190916_E();
        }
        List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, searchStack);
        }
        return itemCount;
    }

    public boolean isAlreadyTrackingCoord(BlockPos pos) {
        return pos.equals((Object)this.pos);
    }

    public boolean renderSearchBlock(int totalCount) {
        int itemCount = this.getSearchedItemCount();
        RenderSearchItemBlock.renderSearch((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, itemCount, totalCount);
        return itemCount > 0;
    }

    public static void renderSearch(double x, double y, double z, int itemCount, int totalCount) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        double ratio = (double)itemCount / (double)totalCount;
        double diff = (1.0 - ratio) / 1.5;
        double size = 1.0 - diff;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(-size, size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(-size, -size, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(size, -size, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(size, size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }
}

