/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.semiblock;

import java.awt.Color;
import java.util.Arrays;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiSearcher;
import me.desht.pneumaticcraft.client.gui.semiblock.GuiLogisticsLiquidFilter;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.inventory.SlotPhantom;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetLogisticsFilterStack;
import me.desht.pneumaticcraft.common.network.PacketSetLogisticsFluidFilterStack;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;

public class GuiLogisticsBase<Logistics extends SemiBlockLogistics>
extends GuiPneumaticContainerBase {
    protected final Logistics logistics;
    private GuiSearcher searchGui;
    private GuiLogisticsLiquidFilter fluidSearchGui;
    private int editingSlot;
    private GuiCheckBox invisible;
    private GuiCheckBox fuzzyMeta;
    private GuiCheckBox fuzzyNBT;
    private GuiCheckBox whitelist;

    public GuiLogisticsBase(InventoryPlayer invPlayer, Logistics requester) {
        super(new ContainerLogistics(invPlayer, (SemiBlockLogistics)requester), null, "pneumaticcraft:textures/gui/gui_logistics_requester.png");
        this.logistics = ((ContainerLogistics)this.field_147002_h).logistics;
        this.field_147000_g = 216;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.searchGui != null) {
            this.field_147002_h.func_75139_a(this.editingSlot).func_75215_d(this.searchGui.getSearchStack());
            NetworkHandler.sendToServer(new PacketSetLogisticsFilterStack((SemiBlockLogistics)this.logistics, this.searchGui.getSearchStack(), this.editingSlot));
            this.searchGui = null;
        }
        if (this.fluidSearchGui != null && this.fluidSearchGui.getFilter() != null) {
            FluidStack filter = new FluidStack(this.fluidSearchGui.getFilter(), 1000);
            ((SemiBlockLogistics)this.logistics).setFilter(this.editingSlot, filter);
            NetworkHandler.sendToServer(new PacketSetLogisticsFluidFilterStack((SemiBlockLogistics)this.logistics, filter, this.editingSlot));
            this.fluidSearchGui = null;
        }
        String invisibleText = I18n.func_135052_a((String)"gui.logistic_frame.invisible", (Object[])new Object[0]);
        this.invisible = new GuiCheckBox(9, this.field_147003_i + this.field_146999_f - 15 - this.field_146289_q.func_78256_a(invisibleText), this.field_147009_r + 7, -12566464, invisibleText);
        this.addWidget(this.invisible);
        this.invisible.setTooltip(Arrays.asList(WordUtils.wrap((String)I18n.func_135052_a((String)"gui.logistic_frame.invisible.tooltip", (Object[])new Object[0]), (int)40).split(System.getProperty("line.separator"))));
        this.addWidget(new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 18, I18n.func_135052_a((String)String.format("gui.%s.filters", SemiBlockManager.getKeyForSemiBlock(this.logistics)), (Object[])new Object[0])));
        this.addWidget(new WidgetLabel(this.field_147003_i + 8, this.field_147009_r + 90, I18n.func_135052_a((String)"gui.logistic_frame.liquid", (Object[])new Object[0])));
        for (int i = 0; i < 9; ++i) {
            this.addWidget(new WidgetFluidStack(i, this.field_147003_i + i * 18 + 8, this.field_147009_r + 101, ((SemiBlockLogistics)this.logistics).getTankFilter(i)));
        }
        this.addInfoTab(I18n.func_135052_a((String)("gui.tab.info." + SemiBlockManager.getKeyForSemiBlock(this.logistics)), (Object[])new Object[0]));
        GuiAnimatedStat filterTab = this.addAnimatedStat("gui.logistic_frame.filter_settings", new ItemStack(Blocks.field_150321_G), -15704048, false);
        filterTab.addPadding(((SemiBlockLogistics)this.logistics).supportsBlacklisting() ? 6 : 4, 26);
        this.fuzzyMeta = new GuiCheckBox(10, 5, 20, -1, I18n.func_135052_a((String)"gui.logistic_frame.fuzzyMeta", (Object[])new Object[0]));
        filterTab.addWidget(this.fuzzyMeta);
        this.fuzzyNBT = new GuiCheckBox(11, 5, 36, -1, I18n.func_135052_a((String)"gui.logistic_frame.fuzzyNBT", (Object[])new Object[0]));
        filterTab.addWidget(this.fuzzyNBT);
        if (((SemiBlockLogistics)this.logistics).supportsBlacklisting()) {
            this.whitelist = new GuiCheckBox(12, 5, 52, -1, I18n.func_135052_a((String)"gui.logistic_frame.whitelist", (Object[])new Object[0]));
            filterTab.addWidget(this.whitelist);
        }
    }

    @Override
    protected int getBackgroundTint() {
        if (!ConfigHandler.client.logisticsGUITint) {
            return super.getBackgroundTint();
        }
        int c = ((SemiBlockLogistics)this.logistics).getColor();
        float[] hsb = Color.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        Color color = Color.getHSBColor(hsb[0], hsb[1] * 0.2f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.invisible.checked = ((SemiBlockLogistics)this.logistics).isInvisible();
        this.fuzzyMeta.checked = ((SemiBlockLogistics)this.logistics).isFuzzyMeta();
        this.fuzzyNBT.checked = ((SemiBlockLogistics)this.logistics).isFuzzyNBT();
        if (((SemiBlockLogistics)this.logistics).supportsBlacklisting()) {
            this.whitelist.checked = ((SemiBlockLogistics)this.logistics).isWhitelist();
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        super.actionPerformed(widget);
        if (widget instanceof WidgetFluidStack) {
            boolean leftClick = Mouse.isButtonDown((int)0);
            boolean middleClick = Mouse.isButtonDown((int)2);
            boolean shift = PneumaticCraftRepressurized.proxy.isSneakingInGui();
            IFluidTank tank = ((SemiBlockLogistics)this.logistics).getTankFilter(widget.getID());
            if (tank.getFluidAmount() > 0) {
                if (middleClick) {
                    ((SemiBlockLogistics)this.logistics).setFilter(widget.getID(), null);
                } else if (leftClick) {
                    tank.drain(shift ? tank.getFluidAmount() / 2 : 1000, true);
                    if (tank.getFluidAmount() < 1000) {
                        tank.drain(1000, true);
                    }
                } else {
                    tank.fill(new FluidStack(tank.getFluid().getFluid(), shift ? tank.getFluidAmount() : 1000), true);
                }
                NetworkHandler.sendToServer(new PacketSetLogisticsFluidFilterStack((SemiBlockLogistics)this.logistics, tank.getFluid(), widget.getID()));
            } else {
                this.fluidSearchGui = new GuiLogisticsLiquidFilter((GuiScreen)this);
                this.editingSlot = widget.getID();
                this.field_146297_k.func_147108_a((GuiScreen)this.fluidSearchGui);
            }
        }
    }

    protected void func_184098_a(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        if (slot instanceof SlotPhantom && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b() && !slot.func_75216_d() && clickedButton == 1) {
            this.editingSlot = slot.getSlotIndex();
            this.searchGui = new GuiSearcher((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.searchGui);
        } else {
            super.func_184098_a(slot, slotId, clickedButton, clickType);
        }
    }
}

