/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.IWidgetListener;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.lang3.text.WordUtils;

public abstract class GuiPneumaticScreenBase
extends GuiScreen
implements IWidgetListener {
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.widgets.clear();
        this.guiLeft = this.field_146294_l / 2 - this.xSize / 2;
        this.guiTop = this.field_146295_m / 2 - this.ySize / 2;
    }

    public void addWidgets(Iterable<IGuiWidget> widgets) {
        for (IGuiWidget widget : widgets) {
            this.addWidget(widget);
        }
    }

    public void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    protected void addLabel(String text, int x, int y) {
        this.addWidget(new WidgetLabel(x, y, text));
    }

    public void removeWidget(IGuiWidget widget) {
        this.widgets.remove(widget);
    }

    protected abstract ResourceLocation getTexture();

    public void func_73863_a(int x, int y, float partialTicks) {
        if (this.getTexture() != null) {
            FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(this.getTexture());
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
        super.func_73863_a(x, y, partialTicks);
        for (IGuiWidget iGuiWidget : this.widgets) {
            iGuiWidget.render(x, y, partialTicks);
        }
        for (IGuiWidget iGuiWidget : this.widgets) {
            iGuiWidget.postRender(x, y, partialTicks);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Object obj : this.field_146292_n) {
            if (!(obj instanceof GuiButtonSpecial)) continue;
            GuiButtonSpecial button = (GuiButtonSpecial)obj;
            if (button.field_146128_h >= x || button.field_146128_h + button.getWidth() <= x || button.field_146129_i >= y || button.field_146129_i + button.getHeight() <= y) continue;
            button.getTooltip(tooltip);
        }
        boolean bl = PneumaticCraftRepressurized.proxy.isSneakingInGui();
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, bl);
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String wrappedLine : localizedLine.split("\\\\n")) {
                    String[] lines = WordUtils.wrap((String)wrappedLine, (int)50).split(System.getProperty("line.separator"));
                    localizedTooltip.addAll(Arrays.asList(lines));
                }
            }
            this.drawHoveringText(localizedTooltip, x, y, this.field_146289_q);
        }
        GlStateManager.func_179131_c((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IGuiWidget widget : new ArrayList<IGuiWidget>(this.widgets)) {
            if (widget.getBounds().contains(mouseX, mouseY)) {
                widget.onMouseClicked(mouseX, mouseY, mouseButton);
                continue;
            }
            widget.onMouseClickedOutsideBounds(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (keyCode == 1) {
            super.func_73869_a(key, keyCode);
        } else {
            for (IGuiWidget widget : this.widgets) {
                widget.onKey(key, keyCode);
            }
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof IGuiAnimatedStat) {
            boolean leftSided = ((IGuiAnimatedStat)((Object)widget)).isLeftSided();
            for (IGuiWidget w : this.widgets) {
                IGuiAnimatedStat stat;
                if (!(w instanceof IGuiAnimatedStat) || widget == (stat = (IGuiAnimatedStat)((Object)w)) || stat.isLeftSided() != leftSided) continue;
                stat.closeWindow();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        for (IGuiWidget widget : this.widgets) {
            widget.handleMouseInput();
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public GuiButton getButtonFromRectangle(int buttonID, Rectangle buttonSize, String buttonText) {
        return new GuiButton(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, buttonText);
    }

    public GuiButtonSpecial getInvisibleButtonFromRectangle(int buttonID, Rectangle buttonSize) {
        return new GuiButtonSpecial(buttonID, buttonSize.x, buttonSize.y, buttonSize.width, buttonSize.height, "");
    }

    public GuiTextField getTextFieldFromRectangle(Rectangle textFieldSize) {
        return new GuiTextField(-1, this.field_146289_q, textFieldSize.x, textFieldSize.y, textFieldSize.width, textFieldSize.height);
    }
}

