/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.common.Reference;
import team.chisel.common.block.BlockCarvablePane;

public enum ChiselModelRegistry implements Reference
{
    INSTANCE;


    public <T extends Block> void register(final @Nonnull T block) {
        if (block instanceof BlockCarvablePane) {
            ModelLoader.setCustomStateMapper(block, (IStateMapper)new StateMapperBase(){

                @Nonnull
                protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                    LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
                    map.remove((Object)((BlockCarvablePane)block).metaProp);
                    VariationData data = ((ICarvable)block).getVariationData(((ICarvable)block).getVariationIndex(state));
                    String name = block.getRegistryName().func_110623_a();
                    while (Character.isDigit(name.charAt(name.length() - 1))) {
                        name = name.substring(0, name.length() - 1);
                    }
                    return new ModelResourceLocation(new ResourceLocation("chisel", data.path), this.func_178131_a(map));
                }
            });
            for (int i = 0; i < ((ICarvable)block).getVariations().length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a(block), (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("chisel", ((ICarvable)block).getVariationData((int)i).path), "inventory"));
            }
            return;
        }
        ModelLoader.setCustomStateMapper(block, (IStateMapper)new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                VariationData data = ((ICarvable)block).getVariationData(((ICarvable)block).getVariationIndex(state));
                String name = block.getRegistryName().func_110623_a();
                while (Character.isDigit(name.charAt(name.length() - 1))) {
                    name = name.substring(0, name.length() - 1);
                }
                return new ModelResourceLocation(new ResourceLocation("chisel", "default"), data.path);
            }
        });
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a(block), (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                VariationData data = ((ICarvable)block).getVariationData(stack.func_77952_i());
                String name = block.getRegistryName().func_110623_a();
                while (Character.isDigit(name.charAt(name.length() - 1))) {
                    name = name.substring(0, name.length() - 1);
                }
                return new ModelResourceLocation(new ResourceLocation("chisel", "default"), data.path);
            }
        });
        ModelLoader.registerItemVariants((Item)Item.func_150898_a(block), (ResourceLocation[])new ResourceLocation[0]);
    }
}

