/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.rangedpumps.block;

import com.raoulvdberge.rangedpumps.RangedPumps;
import com.raoulvdberge.rangedpumps.tile.PumpState;
import com.raoulvdberge.rangedpumps.tile.TilePump;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockPump
extends Block {
    public BlockPump() {
        super(Material.field_151576_e);
        this.setRegistryName("rangedpumps", "pump");
        this.func_149711_c(3.8f);
        this.func_149647_a(RangedPumps.TAB);
    }

    public String func_149739_a() {
        return "block.rangedpumps:pump";
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TilePump) {
            TilePump pump = (TilePump)tile;
            IEnergyStorage energy = (IEnergyStorage)pump.getCapability(CapabilityEnergy.ENERGY, null);
            ITextComponent message = PumpState.getMessage(pump);
            if (message != null) {
                player.func_145747_a(message);
            }
            if (pump.getTank().getFluidAmount() == 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("block.rangedpumps:pump.state_empty", new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}));
            } else {
                String name = pump.getTank().getFluid().getUnlocalizedName();
                Object nameComponent = name.equals("fluid.tile.water") ? new TextComponentString("Water") : (name.equals("fluid.tile.lava") ? new TextComponentString("Lava") : new TextComponentTranslation(name, new Object[0]));
                player.func_145747_a((ITextComponent)new TextComponentTranslation("block.rangedpumps:pump.state", new Object[]{pump.getTank().getFluidAmount(), nameComponent, energy.getEnergyStored(), energy.getMaxEnergyStored()}));
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePump();
    }
}

