/*
 * Decompiled with CFR 0.152.
 */
package cofh.shade.com.typesafe.config.impl;

import cofh.shade.com.typesafe.config.ConfigException;
import cofh.shade.com.typesafe.config.ConfigObject;
import cofh.shade.com.typesafe.config.ConfigOrigin;
import cofh.shade.com.typesafe.config.ConfigRenderOptions;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.impl.AbstractConfigObject;
import cofh.shade.com.typesafe.config.impl.AbstractConfigValue;
import cofh.shade.com.typesafe.config.impl.Path;
import cofh.shade.com.typesafe.config.impl.ResolveContext;
import cofh.shade.com.typesafe.config.impl.ResolveStatus;
import cofh.shade.com.typesafe.config.impl.SerializedConfigValue;
import cofh.shade.com.typesafe.config.impl.SimpleConfig;
import cofh.shade.com.typesafe.config.impl.SimpleConfigOrigin;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class CoFHConfigObject
extends AbstractConfigObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Map<String, AbstractConfigValue> value;
    private final boolean resolved;
    private final boolean ignoresFallbacks;
    private static final String EMPTY_NAME = "empty config";
    private static final CoFHConfigObject emptyInstance = CoFHConfigObject.empty(SimpleConfigOrigin.newSimple("empty config"));

    CoFHConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value, ResolveStatus status, boolean ignoresFallbacks) {
        super(origin);
        if (value == null) {
            throw new ConfigException.BugOrBroken("creating config object with null map");
        }
        this.value = value;
        this.resolved = status == ResolveStatus.RESOLVED;
        this.ignoresFallbacks = ignoresFallbacks;
        if (status != ResolveStatus.fromValues(value.values())) {
            throw new ConfigException.BugOrBroken("Wrong resolved status on " + this);
        }
    }

    CoFHConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value) {
        this(origin, value, ResolveStatus.fromValues(value.values()), false);
    }

    @Override
    public CoFHConfigObject withOnlyKey(String key) {
        return this.withOnlyPath(Path.newKey(key));
    }

    @Override
    public CoFHConfigObject withoutKey(String key) {
        return this.withoutPath(Path.newKey(key));
    }

    @Override
    @Nullable
    protected CoFHConfigObject withOnlyPathOrNull(Path path) {
        String key = path.first();
        Path next = path.remainder();
        AbstractConfigValue v = this.value.get(key);
        if (next != null) {
            v = v instanceof AbstractConfigObject ? ((AbstractConfigObject)v).withOnlyPathOrNull(next) : null;
        }
        if (v == null) {
            return null;
        }
        return new CoFHConfigObject(this.origin(), Collections.singletonMap(key, v), v.resolveStatus(), this.ignoresFallbacks);
    }

    @Override
    CoFHConfigObject withOnlyPath(Path path) {
        CoFHConfigObject o = this.withOnlyPathOrNull(path);
        if (o == null) {
            return new CoFHConfigObject(this.origin(), Collections.emptyMap(), ResolveStatus.RESOLVED, this.ignoresFallbacks);
        }
        return o;
    }

    @Override
    CoFHConfigObject withoutPath(Path path) {
        String key = path.first();
        Path next = path.remainder();
        AbstractConfigValue v = this.value.get(key);
        if (next != null && v instanceof AbstractConfigObject) {
            v = ((AbstractConfigObject)v).withoutPath(next);
            LinkedHashMap<String, AbstractConfigValue> updated = new LinkedHashMap<String, AbstractConfigValue>(this.value);
            updated.put(key, v);
            return new CoFHConfigObject(this.origin(), updated, ResolveStatus.fromValues(updated.values()), this.ignoresFallbacks);
        }
        if (next != null || v == null) {
            return this;
        }
        LinkedHashMap<String, AbstractConfigValue> smaller = new LinkedHashMap<String, AbstractConfigValue>(this.value.size() - 1);
        for (Map.Entry<String, AbstractConfigValue> old : this.value.entrySet()) {
            if (old.getKey().equals(key)) continue;
            smaller.put(old.getKey(), old.getValue());
        }
        return new CoFHConfigObject(this.origin(), smaller, ResolveStatus.fromValues(smaller.values()), this.ignoresFallbacks);
    }

    @Override
    public CoFHConfigObject withValue(String key, ConfigValue v) {
        Map<String, AbstractConfigValue> newMap;
        if (v == null) {
            throw new ConfigException.BugOrBroken("Trying to store null ConfigValue in a ConfigObject");
        }
        if (this.value.isEmpty()) {
            newMap = Collections.singletonMap(key, (AbstractConfigValue)v);
        } else {
            newMap = new LinkedHashMap<String, AbstractConfigValue>(this.value);
            newMap.put(key, (AbstractConfigValue)v);
        }
        return new CoFHConfigObject(this.origin(), newMap, ResolveStatus.fromValues(newMap.values()), this.ignoresFallbacks);
    }

    @Override
    CoFHConfigObject withValue(Path path, ConfigValue v) {
        String key = path.first();
        Path next = path.remainder();
        if (next == null) {
            return this.withValue(key, v);
        }
        AbstractConfigValue child = this.value.get(key);
        if (child instanceof AbstractConfigObject) {
            return this.withValue(key, (ConfigValue)((AbstractConfigObject)child).withValue(next, v));
        }
        SimpleConfig subtree = ((AbstractConfigValue)v).atPath(SimpleConfigOrigin.newSimple("withValue(" + next.render() + ")"), next);
        return this.withValue(key, (ConfigValue)subtree.root());
    }

    @Override
    protected AbstractConfigValue attemptPeekWithPartialResolve(String key) {
        return this.value.get(key);
    }

    private CoFHConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin, boolean newIgnoresFallbacks) {
        return new CoFHConfigObject(newOrigin, this.value, newStatus, newIgnoresFallbacks);
    }

    @Override
    protected CoFHConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin) {
        return this.newCopy(newStatus, newOrigin, this.ignoresFallbacks);
    }

    @Override
    protected CoFHConfigObject withFallbacksIgnored() {
        if (this.ignoresFallbacks) {
            return this;
        }
        return this.newCopy(this.resolveStatus(), this.origin(), true);
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean(this.resolved);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    public Map<String, Object> unwrapped() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            m.put(e.getKey(), e.getValue().unwrapped());
        }
        return m;
    }

    @Override
    protected CoFHConfigObject mergedWithObject(AbstractConfigObject abstractFallback) {
        this.requireNotIgnoringFallbacks();
        if (!(abstractFallback instanceof CoFHConfigObject)) {
            throw new ConfigException.BugOrBroken("should not be reached (merging non-CoFHConfigObject)");
        }
        CoFHConfigObject fallback = (CoFHConfigObject)abstractFallback;
        boolean changed = false;
        boolean allResolved = true;
        LinkedHashMap<String, AbstractConfigValue> merged = new LinkedHashMap<String, AbstractConfigValue>();
        LinkedHashSet<String> allKeys = new LinkedHashSet<String>();
        allKeys.addAll(this.keySet());
        allKeys.addAll(fallback.keySet());
        for (String key : allKeys) {
            AbstractConfigValue first = this.value.get(key);
            AbstractConfigValue second = fallback.value.get(key);
            AbstractConfigValue kept = first == null ? second : (second == null ? first : first.withFallback(second));
            merged.put(key, kept);
            if (first != kept) {
                changed = true;
            }
            if (kept.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            allResolved = false;
        }
        ResolveStatus newResolveStatus = ResolveStatus.fromBoolean(allResolved);
        boolean newIgnoresFallbacks = fallback.ignoresFallbacks();
        if (changed) {
            return new CoFHConfigObject(CoFHConfigObject.mergeOrigins(this, fallback), merged, newResolveStatus, newIgnoresFallbacks);
        }
        if (newResolveStatus != this.resolveStatus() || newIgnoresFallbacks != this.ignoresFallbacks()) {
            return this.newCopy(newResolveStatus, this.origin(), newIgnoresFallbacks);
        }
        return this;
    }

    private CoFHConfigObject modify(AbstractConfigValue.NoExceptionsModifier modifier) {
        try {
            return this.modifyMayThrow(modifier);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    private CoFHConfigObject modifyMayThrow(AbstractConfigValue.Modifier modifier) throws Exception {
        LinkedHashMap<String, AbstractConfigValue> changes = null;
        for (String k : this.keySet()) {
            AbstractConfigValue v;
            AbstractConfigValue modified = modifier.modifyChildMayThrow(k, v = this.value.get(k));
            if (modified == v) continue;
            if (changes == null) {
                changes = new LinkedHashMap<String, AbstractConfigValue>();
            }
            changes.put(k, modified);
        }
        if (changes == null) {
            return this;
        }
        LinkedHashMap<String, AbstractConfigValue> modified = new LinkedHashMap<String, AbstractConfigValue>();
        boolean sawUnresolved = false;
        for (String k : this.keySet()) {
            boolean old = !changes.containsKey(k);
            AbstractConfigValue newValue = (AbstractConfigValue)(!old ? changes : this.value).get(k);
            if (!old && newValue == null) continue;
            modified.put(k, newValue);
            sawUnresolved |= newValue.resolveStatus() == ResolveStatus.UNRESOLVED;
        }
        return new CoFHConfigObject(this.origin(), modified, sawUnresolved ? ResolveStatus.UNRESOLVED : ResolveStatus.RESOLVED, this.ignoresFallbacks());
    }

    @Override
    AbstractConfigObject resolveSubstitutions(ResolveContext context) throws AbstractConfigValue.NotPossibleToResolve {
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return this;
        }
        try {
            return this.modifyMayThrow((key, v) -> {
                if (context.isRestrictedToChild()) {
                    if (key.equals(context.restrictToChild().first())) {
                        Path remainder = context.restrictToChild().remainder();
                        if (remainder != null) {
                            return context.restrict(remainder).resolve(v);
                        }
                        return v;
                    }
                    return v;
                }
                return context.unrestricted().resolve(v);
            });
        }
        catch (AbstractConfigValue.NotPossibleToResolve | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    @Override
    CoFHConfigObject relativized(final Path prefix) {
        return this.modify(new AbstractConfigValue.NoExceptionsModifier(){

            @Override
            public AbstractConfigValue modifyChild(String key, AbstractConfigValue v) {
                return v.relativized(prefix);
            }
        });
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options) {
        if (this.isEmpty()) {
            sb.append("{}");
        } else {
            int innerIndent;
            boolean outerBraces;
            boolean bl = outerBraces = options.getJson() || !atRoot;
            if (outerBraces) {
                innerIndent = indent + 1;
                sb.append("{");
                if (options.getFormatted()) {
                    sb.append('\n');
                }
            } else {
                innerIndent = indent;
            }
            int separatorCount = 0;
            Object[] keys = this.keySet().toArray(new String[this.size()]);
            Arrays.sort(keys);
            for (Object k : keys) {
                AbstractConfigValue v = this.value.get(k);
                if (options.getOriginComments()) {
                    CoFHConfigObject.indent(sb, innerIndent, options);
                    sb.append("# ");
                    sb.append(v.origin().description());
                    sb.append("\n");
                }
                if (options.getComments()) {
                    for (String comment : v.origin().comments()) {
                        CoFHConfigObject.indent(sb, innerIndent, options);
                        sb.append("#");
                        if (!comment.startsWith(" ")) {
                            sb.append(' ');
                        }
                        sb.append(comment);
                        sb.append("\n");
                    }
                }
                CoFHConfigObject.indent(sb, innerIndent, options);
                v.render(sb, innerIndent, false, (String)k, options);
                if (options.getFormatted()) {
                    if (options.getJson()) {
                        sb.append(",");
                        separatorCount = 2;
                    } else {
                        separatorCount = 1;
                    }
                    sb.append('\n');
                    continue;
                }
                sb.append(",");
                separatorCount = 1;
            }
            sb.setLength(sb.length() - separatorCount);
            if (outerBraces) {
                if (options.getFormatted()) {
                    sb.append('\n');
                    CoFHConfigObject.indent(sb, indent, options);
                }
                sb.append("}");
            }
        }
        if (atRoot && options.getFormatted()) {
            sb.append('\n');
        }
    }

    @Override
    public AbstractConfigValue get(Object key) {
        return this.value.get(key);
    }

    private static boolean mapEquals(Map<String, ConfigValue> a, Map<String, ConfigValue> b) {
        Set<String> bKeys;
        Set<String> aKeys = a.keySet();
        if (!aKeys.equals(bKeys = b.keySet())) {
            return false;
        }
        for (String key : aKeys) {
            if (a.get(key).equals(b.get(key))) continue;
            return false;
        }
        return true;
    }

    private static int mapHash(Map<String, ConfigValue> m) {
        ArrayList<String> keys = new ArrayList<String>(m.keySet());
        Collections.sort(keys);
        int valuesHash = 0;
        for (String k : keys) {
            valuesHash += m.get(k).hashCode();
        }
        return 41 * (41 + keys.hashCode()) + valuesHash;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigObject;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigObject) {
            return this.canEqual(other) && CoFHConfigObject.mapEquals(this, (ConfigObject)other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return CoFHConfigObject.mapHash(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.value.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.value.keySet();
    }

    @Override
    public boolean containsValue(Object v) {
        return this.value.containsValue(v);
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        LinkedHashSet<Map.Entry<String, ConfigValue>> entries = new LinkedHashSet<Map.Entry<String, ConfigValue>>();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<String, AbstractConfigValue>(e.getKey(), e.getValue()));
        }
        return entries;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public Collection<ConfigValue> values() {
        return new LinkedHashSet<ConfigValue>(this.value.values());
    }

    static CoFHConfigObject empty() {
        return emptyInstance;
    }

    static CoFHConfigObject empty(ConfigOrigin origin) {
        if (origin == null) {
            return CoFHConfigObject.empty();
        }
        return new CoFHConfigObject(origin, Collections.emptyMap());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

