/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.util.random;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;

public final class WeightedBlock
extends WeightedRandom.Item {
    public final Block block;
    public final int metadata;
    public final IBlockState state;
    public final NBTTagCompound data;

    public WeightedBlock(ItemStack ore) {
        this(ore, 100);
    }

    public WeightedBlock(ItemStack ore, int weight) {
        this(Block.func_149634_a((Item)ore.func_77973_b()), ore.func_77952_i(), null, weight);
    }

    public WeightedBlock(Block ore) {
        this(ore, 0, null, 100);
    }

    public WeightedBlock(Block ore, int metadata) {
        this(ore, metadata, null, 100);
    }

    public WeightedBlock(Block ore, int metadata, NBTTagCompound data, int weight) {
        super(weight);
        this.block = ore;
        this.metadata = metadata;
        this.state = null;
        this.data = data;
    }

    public WeightedBlock(IBlockState ore, NBTTagCompound data, int weight) {
        super(weight);
        this.block = ore.func_177230_c();
        this.metadata = this.block.func_176201_c(ore);
        this.state = ore;
        this.data = data;
    }

    public static boolean isBlockContained(Block block, int metadata, Collection<WeightedBlock> list) {
        for (WeightedBlock rb : list) {
            if (!block.equals(rb.block) || metadata != -1 && rb.metadata != -1 && rb.metadata != metadata) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockContained(Block block, int metadata, WeightedBlock[] list) {
        for (WeightedBlock rb : list) {
            if (!block.equals(rb.block) || metadata != -1 && rb.metadata != -1 && rb.metadata != metadata) continue;
            return true;
        }
        return false;
    }

    public IBlockState getState() {
        return this.state == null ? this.block.func_176203_a(this.metadata) : this.state;
    }

    public NBTTagCompound getData(NBTTagCompound source) {
        if (this.data != null) {
            this.data.func_82580_o("x");
            this.data.func_82580_o("y");
            this.data.func_82580_o("z");
            source.func_179237_a(this.data);
        }
        return source;
    }
}

