/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.generator;

import cofh.cofhworld.parser.GeneratorData;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGenConsecutive;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class GenParserConsecutive
implements IGeneratorParser {
    private static String[] FIELDS = new String[]{"generators"};

    @Override
    public String[] getRequiredFields() {
        return FIELDS;
    }

    @Override
    public boolean isMeta() {
        return true;
    }

    @Override
    @Nonnull
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedBlock> resList, List<WeightedBlock> matList) throws IGeneratorParser.InvalidGeneratorException {
        ArrayList<WorldGenerator> gens;
        ConfigValue genData = genObject.getValue("generators");
        if (genData.valueType() == ConfigValueType.LIST) {
            List<? extends Config> list = genObject.getConfigList("generators");
            gens = new ArrayList(list.size());
            for (Config config : list) {
                gens.add(GeneratorData.parseGenerator(name, config.atKey("generator"), matList));
            }
        } else if (genData.valueType() == ConfigValueType.OBJECT) {
            gens = new ArrayList<WorldGenerator>(1);
            gens.add(GeneratorData.parseGenerator(name, genObject.getConfig("generators").atKey("generator"), matList));
        } else {
            log.error("Invalid object type for generator on line {}.", (Object)genData.origin().lineNumber());
            throw new IGeneratorParser.InvalidGeneratorException("Invalid object type", genData.origin());
        }
        return new WorldGenConsecutive(gens);
    }
}

