/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.fluidhandler.FluidMatch;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.ingredient.IngredientHelpers;
import org.cyclops.cyclopscore.helper.Helpers;

public class IngredientMatcherFluidStack
implements IIngredientMatcher<FluidStack, Integer> {
    private static final Map<Fluid, Integer> FLUID_ID_CACHE = Maps.newIdentityHashMap();

    @Override
    public boolean isInstance(Object object) {
        return object == null || object instanceof FluidStack;
    }

    @Override
    public Integer getAnyMatchCondition() {
        return 0;
    }

    @Override
    public Integer getExactMatchCondition() {
        return 7;
    }

    @Override
    public Integer getExactMatchNoQuantityCondition() {
        return 3;
    }

    @Override
    public Integer withCondition(Integer matchCondition, Integer with) {
        return matchCondition | with;
    }

    @Override
    public Integer withoutCondition(Integer matchCondition, Integer without) {
        return matchCondition & ~without.intValue();
    }

    @Override
    public boolean hasCondition(Integer matchCondition, Integer searchCondition) {
        return (matchCondition & searchCondition) > 0;
    }

    @Override
    public boolean matches(FluidStack a, FluidStack b, Integer matchCondition) {
        return FluidMatch.areFluidStacksEqual(a, b, matchCondition);
    }

    @Override
    public FluidStack getEmptyInstance() {
        return null;
    }

    @Override
    public int hash(FluidStack instance) {
        if (instance == null) {
            return 0;
        }
        int code = 1;
        code = 31 * code + instance.getFluid().hashCode();
        code = 31 * code + instance.amount;
        if (instance.tag != null) {
            code = 31 * code + instance.tag.hashCode();
        }
        return code;
    }

    @Override
    public FluidStack copy(FluidStack instance) {
        if (instance == null) {
            return null;
        }
        return instance.copy();
    }

    @Override
    public long getQuantity(FluidStack instance) {
        if (instance == null) {
            return 0L;
        }
        return instance.amount;
    }

    @Override
    public FluidStack withQuantity(FluidStack instance, long quantity) {
        if (quantity == 0L) {
            return null;
        }
        if (instance == null) {
            return new FluidStack(FluidRegistry.WATER, Helpers.castSafe((long)quantity));
        }
        if ((long)instance.amount == quantity) {
            return instance;
        }
        FluidStack copy = instance.copy();
        copy.amount = Helpers.castSafe((long)quantity);
        return copy;
    }

    @Override
    public long getMaximumQuantity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int conditionCompare(Integer a, Integer b) {
        return Integer.compare(a, b);
    }

    @Override
    public String localize(FluidStack instance) {
        return instance.getLocalizedName();
    }

    @Override
    public int compare(FluidStack o1, FluidStack o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getFluid() == o2.getFluid()) {
            if (o1.amount == o2.amount) {
                return IngredientHelpers.compareTags((NBTBase)o1.tag, (NBTBase)o2.tag);
            }
            return o1.amount - o2.amount;
        }
        return IngredientMatcherFluidStack.getFluidId(o1.getFluid()) - IngredientMatcherFluidStack.getFluidId(o2.getFluid());
    }

    public static int getFluidId(Fluid fluid) {
        if (FLUID_ID_CACHE.isEmpty()) {
            FLUID_ID_CACHE.putAll(FluidRegistry.getRegisteredFluidIDs());
        }
        return FLUID_ID_CACHE.getOrDefault(fluid, -1);
    }
}

