/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public abstract class MixedIngredientsAdapter
implements IMixedIngredients {
    public boolean equals(Object obj) {
        if (obj instanceof IMixedIngredients) {
            IMixedIngredients that = (IMixedIngredients)obj;
            if (Sets.newHashSet(this.getComponents()).equals(Sets.newHashSet(that.getComponents()))) {
                for (IngredientComponent<?, ?> component : this.getComponents()) {
                    List<?> thisInstances = this.getInstances(component);
                    List<?> thatInstances = that.getInstances(component);
                    IIngredientMatcher<?, ?> matcher = component.getMatcher();
                    if (thisInstances.size() != thatInstances.size()) continue;
                    for (int i = 0; i < thisInstances.size(); ++i) {
                        if (matcher.matchesExactly(thisInstances.get(i), thatInstances.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 902;
        for (IngredientComponent<?, ?> component : this.getComponents()) {
            hash |= component.hashCode() << 2;
            IIngredientMatcher<?, ?> matcher = component.getMatcher();
            for (Object instance : this.getInstances(component)) {
                hash |= matcher.hash(instance);
            }
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IngredientComponent<?, ?> component : this.getComponents()) {
            sb.append('{');
            sb.append(component);
            sb.append(':');
            sb.append(this.getInstances(component));
            sb.append('}');
        }
        return "[MixedIngredients ingredients: " + sb + "]";
    }

    @Override
    public int compareTo(IMixedIngredients that) {
        int compComp = MixedIngredientsAdapter.compareCollection(this.getComponents(), that.getComponents());
        if (compComp != 0) {
            return compComp;
        }
        for (IngredientComponent<?, ?> component : this.getComponents()) {
            int compInstance = MixedIngredientsAdapter.compareCollection(this.getInstances(component), that.getInstances(component), component.getMatcher());
            if (compInstance == 0) continue;
            return compInstance;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compareCollection(Collection<? super T> a, Collection<? super T> b) {
        if (a.size() != b.size()) {
            return a.size() - b.size();
        }
        Object[] aArray = a.toArray();
        Object[] bArray = b.toArray();
        for (int i = 0; i < aArray.length; ++i) {
            int compComp = ((Comparable)aArray[i]).compareTo((Comparable)bArray[i]);
            if (compComp == 0) continue;
            return compComp;
        }
        return 0;
    }

    public static <T> int compareCollection(Collection<? super T> a, Collection<? super T> b, Comparator<T> comparator) {
        if (a.size() != b.size()) {
            return a.size() - b.size();
        }
        Object[] aArray = a.toArray();
        Object[] bArray = b.toArray();
        for (int i = 0; i < aArray.length; ++i) {
            int compComp = comparator.compare(aArray[i], bArray[i]);
            if (compComp == 0) continue;
            return compComp;
        }
        return 0;
    }
}

