/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public interface IPrototypedIngredient<T, M>
extends Comparable<IPrototypedIngredient<?, ?>> {
    public IngredientComponent<T, M> getComponent();

    public T getPrototype();

    public M getCondition();

    public static <T, M> NBTTagCompound serialize(IPrototypedIngredient<T, M> prototypedIngredient) {
        NBTTagCompound tag = new NBTTagCompound();
        IngredientComponent<T, M> component = prototypedIngredient.getComponent();
        tag.func_74778_a("ingredientComponent", component.getName().toString());
        IIngredientSerializer<T, M> serializer = component.getSerializer();
        tag.func_74782_a("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
        tag.func_74782_a("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
        return tag;
    }

    public static PrototypedIngredient deserialize(NBTTagCompound tag) throws IllegalArgumentException {
        if (!tag.func_150297_b("ingredientComponent", 8)) {
            throw new IllegalArgumentException("Could not find a ingredientComponent entry in the given tag");
        }
        if (!tag.func_74764_b("prototype")) {
            throw new IllegalArgumentException("Could not find a prototype entry in the given tag");
        }
        if (!tag.func_74764_b("condition")) {
            throw new IllegalArgumentException("Could not find a condition entry in the given tag");
        }
        String componentName = tag.func_74779_i("ingredientComponent");
        IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
        if (component == null) {
            throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
        }
        IIngredientSerializer serializer = component.getSerializer();
        Object prototype = serializer.deserializeInstance(tag.func_74781_a("prototype"));
        Object condition = serializer.deserializeCondition(tag.func_74781_a("condition"));
        return new PrototypedIngredient(component, prototype, condition);
    }
}

