/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.io.IOException;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.util.CommandUtilServer;
import mezz.jei.util.GiveMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class PacketGiveItemStack
extends PacketJei {
    private final ItemStack itemStack;
    private final GiveMode giveMode;

    public PacketGiveItemStack(ItemStack itemStack, GiveMode giveMode) {
        this.itemStack = itemStack;
        this.giveMode = giveMode;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.GIVE_ITEM;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        NBTTagCompound nbt = this.itemStack.serializeNBT();
        buf.func_150786_a(nbt);
        buf.func_179249_a((Enum)this.giveMode);
    }

    public static void readPacketData(PacketBuffer buf, EntityPlayer player) throws IOException {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP sender = (EntityPlayerMP)player;
            NBTTagCompound itemStackSerialized = buf.func_150793_b();
            if (itemStackSerialized != null) {
                GiveMode giveMode = (GiveMode)buf.func_179257_a(GiveMode.class);
                ItemStack itemStack = new ItemStack(itemStackSerialized);
                if (!itemStack.func_190926_b()) {
                    CommandUtilServer.executeGive(sender, itemStack, giveMode);
                }
            }
        }
    }
}

