/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WorldIDCleanup {
    private final TinyRegistry BLOCKS = new TinyRegistry(ForgeRegistries.BLOCKS, "minecraft:blocks");

    public WorldIDCleanup(File worldDirectory) throws Exception {
        File levelFile = new File(worldDirectory, "level.dat");
        if (!levelFile.exists()) {
            throw new Exception("Invalid world directory!");
        }
        NBTTagCompound levelData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(levelFile));
        if (!levelData.func_74764_b("FML")) {
            throw new Exception("Non-Forge level.dat!");
        }
        NBTTagCompound levelData1 = levelData.func_74775_l("FML");
        if (!levelData1.func_74764_b("Registries")) {
            throw new Exception("Corrupt level.dat!");
        }
        NBTTagCompound registriesCompound = levelData1.func_74775_l("Registries");
        if (registriesCompound.func_74764_b(this.BLOCKS.name)) {
            this.BLOCKS.add(registriesCompound.func_74775_l(this.BLOCKS.name));
        }
    }

    public void cleanup() {
    }

    public static class TinyRegistry {
        private final IForgeRegistry parent;
        private final TObjectIntMap<ResourceLocation> map = new TObjectIntHashMap();
        private final TIntHashSet idsInUse = new TIntHashSet();
        private final String name;

        public TinyRegistry(IForgeRegistry parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private void add(NBTTagCompound compound) {
            NBTTagList list = compound.func_150295_c("ids", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound c = list.func_150305_b(i);
                if (!c.func_74764_b("K") || !c.func_74764_b("V")) continue;
                this.add(new ResourceLocation(c.func_74779_i("K")), c.func_74762_e("V"));
            }
        }

        private void add(ResourceLocation location, int id) {
            this.map.put((Object)location, id);
            if (this.parent.containsKey(location)) {
                this.idsInUse.add(id);
            }
        }

        public boolean shouldRemove(int id) {
            return !this.idsInUse.contains(id);
        }
    }
}

