/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery.sub;

import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBlockBakery;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.model.bakery.generation.ISimpleBlockBakery;
import codechicken.lib.model.bakery.key.IBlockStateKeyGenerator;
import codechicken.lib.model.bakery.key.IItemStackKeyGenerator;
import codechicken.lib.model.bakery.sub.SubBlockStateKeyGenerator;
import codechicken.lib.model.bakery.sub.SubItemStackKeyGenerator;
import codechicken.lib.texture.TextureUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SubBlockBakery
implements ILayeredBlockBakery,
TextureUtils.IIconRegister {
    private final Map<Integer, IBlockBakery> subBakeries = new HashMap<Integer, IBlockBakery>();
    private final SubBlockStateKeyGenerator blockKeyGenerator = new SubBlockStateKeyGenerator();
    private final SubItemStackKeyGenerator itemKeyGenerator = new SubItemStackKeyGenerator();

    public void registerSubBakery(int meta, IBlockBakery bakery) {
        this.subBakeries.put(meta, bakery);
    }

    public void registerSubBakery(int meta, IBlockBakery bakery, IBlockStateKeyGenerator blockKeyGen) {
        this.registerSubBakery(meta, bakery, blockKeyGen, null);
    }

    public void registerSubBakery(int meta, IBlockBakery bakery, IItemStackKeyGenerator itemKeyGen) {
        this.registerSubBakery(meta, bakery, null, itemKeyGen);
    }

    public void registerSubBakery(int meta, IBlockBakery bakery, IBlockStateKeyGenerator blockKeyGen, IItemStackKeyGenerator itemKeyGen) {
        this.subBakeries.put(meta, bakery);
        if (blockKeyGen != null) {
            this.blockKeyGenerator.register(meta, blockKeyGen);
        }
        if (itemKeyGen != null) {
            this.itemKeyGenerator.register(meta, itemKeyGen);
        }
    }

    public SubBlockBakery registerKeyGens(Block block) {
        this.registerBlockKeyGen(block);
        this.registerItemKeyGen(Item.func_150898_a((Block)block));
        return this;
    }

    public SubBlockBakery registerBlockKeyGen(Block block) {
        ModelBakery.registerBlockKeyGenerator(block, this.blockKeyGenerator);
        return this;
    }

    public SubBlockBakery registerItemKeyGen(Item block) {
        ModelBakery.registerItemKeyGenerator(block, this.itemKeyGenerator);
        return this;
    }

    public SubBlockStateKeyGenerator getBlockKeyGen() {
        return this.blockKeyGenerator;
    }

    public SubItemStackKeyGenerator getItemKeyGen() {
        return this.itemKeyGenerator;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        IBlockBakery bakery = this.subBakeries.get(state.func_177230_c().func_176201_c((IBlockState)state));
        if (bakery instanceof ISimpleBlockBakery) {
            if (state.func_177230_c().canRenderInLayer((IBlockState)state, layer)) {
                return ((ISimpleBlockBakery)bakery).bakeQuads(face, state);
            }
        } else if (bakery instanceof ILayeredBlockBakery) {
            return ((ILayeredBlockBakery)bakery).bakeLayerFace(face, layer, state);
        }
        return ImmutableList.of();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockBakery bakery = this.subBakeries.get(state.func_177230_c().func_176201_c((IBlockState)state));
        if (bakery == null) {
            return state;
        }
        return bakery.handleState(state, world, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        IBlockBakery bakery = this.subBakeries.get(stack.func_77960_j());
        if (bakery == null) {
            return ImmutableList.of();
        }
        return bakery.bakeItemQuads(face, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        for (IBlockBakery bakery : this.subBakeries.values()) {
            if (!(bakery instanceof TextureUtils.IIconRegister)) continue;
            ((TextureUtils.IIconRegister)((Object)bakery)).registerIcons(textureMap);
        }
    }
}

