/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.rendering;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.funkylocomotion.blocks.BlockStickyFrame;
import com.rwtema.funkylocomotion.blocks.FLBlocks;
import com.rwtema.funkylocomotion.blocks.TileFrameProjector;
import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import com.rwtema.funkylocomotion.eventhandler.ClientTimer;
import com.rwtema.funkylocomotion.fakes.FakeWorldClient;
import com.rwtema.funkylocomotion.helper.NullHelper;
import com.rwtema.funkylocomotion.items.FLItems;
import com.rwtema.funkylocomotion.rendering.ChunkRerenderer;
import com.rwtema.funkylocomotion.rendering.TESRMoving;
import com.rwtema.funkylocomotion.rendering.TESRProjector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.Validate;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class FLRenderingRegistration {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.BOOSTER);
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.FRAME_PROJECTOR);
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.SLIDER);
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.TELEPORTER);
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.MASS_FRAME_CORNER);
        FLRenderingRegistration.registerBlockItemModel(FLBlocks.MASS_FRAME_EDGE);
        ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)FLBlocks.PUSHER))), (int)0, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:pusher", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)FLBlocks.PUSHER))), (int)1, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:puller", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FLItems.WRENCH, (int)0, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FLItems.WRENCH, (int)1, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench_eye", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FLItems.WRENCH, (int)2, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:wrench_hammer", "inventory"));
        for (BlockStickyFrame frame : FLBlocks.FRAMES) {
            for (int i = 0; i < 16; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)((Item)Validate.notNull((Object)Item.func_150898_a((Block)frame))), (int)i, (ModelResourceLocation)new ModelResourceLocation("funkylocomotion:frame", "inventory"));
            }
        }
        FLRenderingRegistration.registerRenderers();
    }

    private static void registerBlockItemModel(Block block) {
        Item item = (Item)Validate.notNull((Object)Item.func_150898_a((Block)block));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory"));
    }

    private static void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileMovingClient.class, (TileEntitySpecialRenderer)TESRMoving.INSTANCE);
        ClientRegistry.bindTileEntitySpecialRenderer(TileFrameProjector.class, (TileEntitySpecialRenderer)TESRProjector.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ClientTimer());
        MinecraftForge.EVENT_BUS.register((Object)new ChunkRerenderer());
        FakeWorldClient.register();
        ModelLoader.setCustomStateMapper((Block)NullHelper.notNull(FLBlocks.MOVING), blockIn -> ImmutableMap.of());
        for (final BlockStickyFrame frame : FLBlocks.FRAMES) {
            ModelLoader.setCustomStateMapper((Block)frame, (IStateMapper)new IStateMapper(){
                Map<IBlockState, ModelResourceLocation> mapStateModelLocations = Maps.newLinkedHashMap();
                DefaultStateMapper mapper = new DefaultStateMapper();

                @Nonnull
                public Map<IBlockState, ModelResourceLocation> func_178130_a(@Nonnull Block blockIn) {
                    for (int i = 0; i < 16; ++i) {
                        IBlockState state = frame.func_176203_a(i);
                        LinkedHashMap<PropertyBool, Comparable> values = new LinkedHashMap<PropertyBool, Comparable>();
                        ArrayList list = Lists.newArrayList((Object[])EnumFacing.values());
                        list.sort(Comparator.comparing(EnumFacing::func_176742_j));
                        for (EnumFacing facing : list) {
                            values.put(BlockStickyFrame.DIR_OPEN[facing.ordinal()], state.func_177229_b((IProperty)BlockStickyFrame.DIR_OPEN[facing.ordinal()]));
                        }
                        Validate.isTrue((boolean)frame.func_176194_O().func_177619_a().contains((Object)state));
                        this.mapStateModelLocations.put(state, new ModelResourceLocation("funkylocomotion:frame", this.mapper.func_178131_a(values)));
                    }
                    return this.mapStateModelLocations;
                }
            });
        }
    }
}

