/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.casting.CastingRuleMatchedFunction;
import stanhebben.zenscript.type.casting.ICastingRule;
import stanhebben.zenscript.type.casting.ICastingRuleDelegate;
import stanhebben.zenscript.util.ZenPosition;

public class ZenTypeFunction
extends ZenType {
    protected final ZenType returnType;
    protected final ZenType[] argumentTypes;
    private final String name;
    private final Map<ZenType, CastingRuleMatchedFunction> implementedInterfaces = new HashMap<ZenType, CastingRuleMatchedFunction>();

    public ZenTypeFunction(ZenType returnType, List<ParsedFunctionArgument> arguments) {
        this.returnType = returnType;
        this.argumentTypes = new ZenType[arguments.size()];
        for (int i = 0; i < this.argumentTypes.length; ++i) {
            this.argumentTypes[i] = arguments.get(i).getType();
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("function(");
        boolean first = true;
        for (ZenType type : this.argumentTypes) {
            if (first) {
                first = false;
            } else {
                nameBuilder.append(',');
            }
            nameBuilder.append(type.getName());
        }
        nameBuilder.append(returnType.getName());
        this.name = nameBuilder.toString();
    }

    public ZenTypeFunction(ZenType returnType, ZenType[] argumentTypes) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("function(");
        boolean first = true;
        for (ZenType type : argumentTypes) {
            if (first) {
                first = false;
            } else {
                nameBuilder.append(',');
            }
            nameBuilder.append(type.getName());
        }
        nameBuilder.append(')');
        nameBuilder.append(returnType.getName());
        this.name = nameBuilder.toString();
    }

    @Override
    public String getAnyClassName(IEnvironmentGlobal global) {
        throw new UnsupportedOperationException("functions cannot yet be used as any value");
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        environment.error(position, "Functions have no members");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        environment.error(position, "Functions have no static members");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return null;
    }

    @Override
    public void constructCastingRules(IEnvironmentGlobal environment, ICastingRuleDelegate rules, boolean followCasters) {
        if (followCasters) {
            this.constructExpansionCastingRules(environment, rules);
        }
    }

    @Override
    public ICastingRule getCastingRule(ZenType type, IEnvironmentGlobal environment) {
        if (this.implementedInterfaces.containsKey(type)) {
            return this.implementedInterfaces.get(type);
        }
        Class cls = type.toJavaClass();
        System.out.println("Can cast this function to " + cls.getName() + "?");
        if (cls.isInterface() && cls.getMethods().length == 1) {
            Method method = cls.getMethods()[0];
            ZenType methodReturnType = environment.getType(method.getGenericReturnType());
            ICastingRule returnCastingRule = null;
            if (!this.returnType.equals(methodReturnType) && (returnCastingRule = this.returnType.getCastingRule(environment.getType(method.getGenericReturnType()), environment)) == null) {
                System.out.println("Return types don't match");
                return null;
            }
            Type[] methodParameters = method.getGenericParameterTypes();
            if (methodParameters.length < this.argumentTypes.length) {
                System.out.println("Argument count doesn't match");
                return null;
            }
            ICastingRule[] argumentCastingRules = new ICastingRule[this.argumentTypes.length];
            for (int i = 0; i < argumentCastingRules.length; ++i) {
                ZenType argumentType = environment.getType(methodParameters[i]);
                if (argumentType.equals(this.argumentTypes[i])) continue;
                argumentCastingRules[i] = argumentType.getCastingRule(this.argumentTypes[i], environment);
                if (argumentCastingRules[i] != null) continue;
                System.out.println("Argument " + i + " doesn't match");
                System.out.println("Cannot cast " + argumentType.getName() + " to " + this.argumentTypes[i].getName());
                return null;
            }
            CastingRuleMatchedFunction castingRule = new CastingRuleMatchedFunction(this, type, returnCastingRule, argumentCastingRules);
            this.implementedInterfaces.put(type, castingRule);
            System.out.println("Can cast this function");
            return castingRule;
        }
        return null;
    }

    @Override
    public org.objectweb.asm.Type toASMType() {
        return org.objectweb.asm.Type.getType(Object.class);
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "Ljava/lang/Object;";
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        environment.error(position, "cannot apply operators on a function");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        environment.error(position, "cannot apply operators on a function");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        environment.error(position, "cannot apply operators on a function");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        environment.error(position, "cannot apply operators on a function");
        return new ExpressionInvalid(position, ZenTypeAny.INSTANCE);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        return null;
    }

    @Override
    public ZenType[] predictCallTypes(int numArguments) {
        return Arrays.copyOf(this.argumentTypes, numArguments);
    }

    @Override
    public Class toJavaClass() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    public ZenType getReturnType() {
        return this.returnType;
    }

    public ZenType[] getArgumentTypes() {
        return this.argumentTypes;
    }
}

