/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.recipes.ICraftingRecipe;
import crafttweaker.api.recipes.IRecipeAction;
import crafttweaker.api.recipes.IRecipeFunction;
import crafttweaker.api.recipes.IRecipeManager;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeShaped;
import crafttweaker.mc1120.recipes.MCRecipeShapeless;
import crafttweaker.mc1120.recipes.MCRecipeWrapper;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.Optional;

public final class MCRecipeManager
implements IRecipeManager {
    public static final List<ActionBaseAddRecipe> recipesToAdd = new ArrayList<ActionBaseAddRecipe>();
    public static final List<ActionBaseRemoveRecipes> recipesToRemove = new ArrayList<ActionBaseRemoveRecipes>();
    public static final ActionRemoveRecipesNoIngredients actionRemoveRecipesNoIngredients = new ActionRemoveRecipesNoIngredients();
    public static Set<Map.Entry<ResourceLocation, IRecipe>> recipes;
    public static List<MCRecipeBase> transformerRecipes;
    private static TIntSet usedHashes;
    private static HashSet<String> usedRecipeNames;

    private static boolean matchesItem(ItemStack input, IIngredient ingredient) {
        return ingredient == null ? input.func_190926_b() : !input.func_190926_b() && ingredient.matches(CraftTweakerMC.getIItemStack(input));
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input instanceof String) {
            return ingredient.contains(CraftTweakerMC.getOreDict((String)input));
        }
        if (input instanceof ItemStack) {
            return MCRecipeManager.matchesItem((ItemStack)input, ingredient);
        }
        if (input instanceof Ingredient) {
            ItemStack[] matchingStacks = ((Ingredient)input).func_193365_a();
            return matchingStacks.length > 0 && MCRecipeManager.matchesItem(matchingStacks[0], ingredient);
        }
        return false;
    }

    @Deprecated
    public static String saveToString(Object ingredient) {
        if (ingredient == null) {
            return "_";
        }
        return ingredient.toString();
    }

    @Deprecated
    public static String saveToString(IIngredient ingredient) {
        return MCRecipeManager.saveToString((Object)ingredient);
    }

    public static String cleanRecipeName(String s) {
        if (s.contains(":")) {
            CraftTweakerAPI.logWarning("Recipe name [" + s + "] may not contain a ':', replacing with '_'!");
        }
        return s.replace(":", "_");
    }

    public static void cleanUpRecipeList() {
        Iterator<ActionBaseAddRecipe> iterator = recipesToAdd.iterator();
        while (iterator.hasNext()) {
            MCRecipeBase recipe = iterator.next().getRecipe();
            if (ForgeRegistries.RECIPES.containsKey(recipe.getRegistryName())) continue;
            CraftTweakerAPI.logWarning("Recipe " + recipe.toCommandString() + " was created but not added to the Recipe Registry, check for other errors in your log!");
            iterator.remove();
        }
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        if (recipes == null) {
            recipes = ForgeRegistries.RECIPES.getEntries();
        }
        for (Map.Entry<ResourceLocation, IRecipe> ent : recipes) {
            ItemStack stack = ent.getValue().func_77571_b();
            if (stack.func_190926_b() || !ingredient.matches(CraftTweakerMC.getIItemStack(stack))) continue;
            if (ent.getValue() instanceof MCRecipeBase) {
                results.add((MCRecipeBase)ent.getValue());
                continue;
            }
            results.add(new MCRecipeWrapper(ent.getValue()));
        }
        return results;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        if (recipes == null) {
            recipes = ForgeRegistries.RECIPES.getEntries();
        }
        for (Map.Entry<ResourceLocation, IRecipe> recipeEntry : recipes) {
            IRecipe recipe = recipeEntry.getValue();
            if (recipe instanceof MCRecipeBase) {
                results.add((MCRecipeBase)recipe);
                continue;
            }
            results.add(new MCRecipeWrapper(recipe));
        }
        return results;
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, false, false));
    }

    @Override
    public void addShaped(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, false, false));
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(output, ingredients, function, action, true, false));
    }

    @Override
    public void addShapedMirrored(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, true, false));
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(output, ingredients, function, action));
    }

    @Override
    public void addShapeless(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(name, output, ingredients, function, action, false));
    }

    @Override
    public void addHiddenShapeless(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
        boolean valid = output != null;
        for (IIngredient ing : ingredients) {
            if (ing != null) continue;
            valid = false;
        }
        if (!valid) {
            CraftTweakerAPI.logError("Null not allowed in shapeless recipes! Recipe for: " + output + " not created!");
            return;
        }
        recipesToAdd.add(new ActionAddShapelessRecipe(name, output, ingredients, function, action, true));
    }

    @Override
    public void addHiddenShaped(String name, IItemStack output, IIngredient[][] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action, @Optional boolean mirrored) {
        recipesToAdd.add(new ActionAddShapedRecipe(name, output, ingredients, function, action, mirrored, true));
    }

    @Override
    public void removeAll() {
        recipesToRemove.add(new ActionRemoveAllRecipes());
    }

    @Override
    public void remove(IIngredient output, @Optional boolean nbtMatch) {
        actionRemoveRecipesNoIngredients.addOutput(output, nbtMatch);
    }

    @Override
    public void removeByRecipeName(String recipeName, @Optional IItemStack outputFilter) {
        recipesToRemove.add(new ActionRemoveRecipeByRecipeName(recipeName, outputFilter));
    }

    @Override
    public void removeByRegex(String regexString, @Optional IItemStack outputFilter) {
        recipesToRemove.add(new ActionRemoveRecipeByRegex(regexString, outputFilter));
    }

    @Override
    public void removeByMod(String modid) {
        recipesToRemove.add(new ActionRemoveRecipeByMod(modid));
    }

    @Override
    public void removeShaped(IIngredient output, IIngredient[][] ingredients) {
        recipesToRemove.add(new ActionRemoveShapedRecipes(output, ingredients));
    }

    @Override
    public void removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        recipesToRemove.add(new ActionRemoveShapelessRecipes(output, ingredients, wildcard));
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = CraftTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.func_70299_a(i, iContents[i]);
        }
        ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)inventory, null);
        if (result.func_190926_b()) {
            return null;
        }
        return CraftTweakerMC.getIItemStack(result);
    }

    @Override
    public void replaceAllOccurences(IIngredient toReplace, IIngredient replaceWith, IIngredient forOutput) {
        recipesToRemove.add(new ActionReplaceAllOccurences(toReplace, replaceWith, forOutput));
    }

    static {
        transformerRecipes = new ArrayList<MCRecipeBase>();
        usedHashes = new TIntHashSet();
        usedRecipeNames = new HashSet();
    }

    private static class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean func_75145_c(EntityPlayer var1) {
            return false;
        }
    }

    private static class ActionAddShapelessRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapelessRecipe(IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action) {
            this(null, output, ingredients, function, action, false);
        }

        public ActionAddShapelessRecipe(String name, IItemStack output, IIngredient[] ingredients, @Optional IRecipeFunction function, @Optional IRecipeAction action, boolean hidden) {
            super(new MCRecipeShapeless(ingredients, output, function, action, hidden), output, false);
            this.setName(name);
        }
    }

    private static class ActionAddShapedRecipe
    extends ActionBaseAddRecipe {
        public ActionAddShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            this(null, output, ingredients, function, action, mirrored, hidden);
        }

        public ActionAddShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored, boolean hidden) {
            super(new MCRecipeShaped(ingredients, output, function, action, mirrored, hidden), output, true);
            this.setName(name);
        }
    }

    public static class ActionDummyAddRecipe
    extends ActionBaseAddRecipe {
        public ActionDummyAddRecipe(MCRecipeBase recipe, IItemStack output, boolean isShaped) {
            super(recipe, output, isShaped);
        }

        @Override
        public void apply() {
        }

        @Override
        protected void setName(String name) {
            super.setName(name);
            this.recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name));
        }
    }

    public static class ActionBaseAddRecipe
    implements IAction {
        protected MCRecipeBase recipe;
        protected IItemStack output;
        protected boolean isShaped;
        protected String name;

        @Deprecated
        public ActionBaseAddRecipe() {
        }

        private ActionBaseAddRecipe(MCRecipeBase recipe, IItemStack output, boolean isShaped) {
            this.recipe = recipe;
            this.output = output;
            this.isShaped = isShaped;
            if (recipe.hasTransformers()) {
                transformerRecipes.add(recipe);
            }
        }

        public IItemStack getOutput() {
            return this.output;
        }

        public void setOutput(IItemStack output) {
            this.output = output;
        }

        public String getName() {
            return this.name;
        }

        protected void setName(String name) {
            if (name != null) {
                String proposedName = MCRecipeManager.cleanRecipeName(name);
                if (usedRecipeNames.contains(proposedName)) {
                    this.name = this.calculateName();
                    CraftTweakerAPI.logWarning("Recipe name [" + name + "] has duplicate uses, defaulting to calculated hash!");
                } else {
                    this.name = proposedName;
                }
            } else {
                this.name = this.calculateName();
            }
            usedRecipeNames.add(this.name);
        }

        public String calculateName() {
            int hash = this.recipe.toCommandString().hashCode();
            while (usedHashes.contains(hash)) {
                ++hash;
            }
            usedHashes.add(hash);
            return (this.isShaped ? "ct_shaped" : "ct_shapeless") + hash;
        }

        @Override
        public void apply() {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)this.recipe.setRegistryName(new ResourceLocation("crafttweaker", this.name)));
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Adding " + (this.isShaped ? "shaped" : "shapeless") + " recipe for " + this.output.getDisplayName() + " with name " + this.name;
            }
            return "Trying to add " + (this.isShaped ? "shaped" : "shapeless") + "recipe without correct output";
        }

        public MCRecipeBase getRecipe() {
            return this.recipe;
        }
    }

    public static class ActionRemoveAllRecipes
    extends ActionBaseRemoveRecipes {
        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing all crafting recipes";
        }
    }

    public static class ActionRemoveRecipeByRegex
    extends ActionBaseRemoveRecipes {
        String regexCheck;
        IItemStack filter;

        public ActionRemoveRecipeByRegex(String regexCheck, IItemStack filter) {
            this.regexCheck = regexCheck;
            this.filter = filter;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            Pattern p = Pattern.compile(this.regexCheck);
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                ResourceLocation resourceLocation = recipe.getKey();
                Matcher m = p.matcher(resourceLocation.toString());
                if (!m.matches()) continue;
                if (this.filter != null) {
                    if (!this.filter.matches(CraftTweakerMC.getIItemStack(recipe.getValue().func_77571_b()))) continue;
                    toRemove.add(recipe.getKey());
                    continue;
                }
                toRemove.add(resourceLocation);
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.regexCheck != null) {
                if (this.filter != null) {
                    return "Removing all recipes matching this regex: \"" + this.regexCheck + "\", Matching filter: " + this.filter.getDisplayName();
                }
                return "Removing all recipes matching this regex: \"" + this.regexCheck + "\"";
            }
            return "No regex String for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipeByMod
    extends ActionBaseRemoveRecipes {
        String modid;

        public ActionRemoveRecipeByMod(String modid) {
            this.modid = modid;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (!recipe.getKey().func_110624_b().equalsIgnoreCase(this.modid)) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            return "Removing recipes matching: " + this.modid;
        }
    }

    public static class ActionRemoveRecipeByRecipeName
    extends ActionBaseRemoveRecipes {
        String recipeName;
        IItemStack filter;

        public ActionRemoveRecipeByRecipeName(String recipeName, IItemStack filter) {
            this.recipeName = recipeName;
            this.filter = filter;
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                if (!recipe.getKey().toString().equals(this.recipeName)) continue;
                if (this.filter != null) {
                    if (!this.filter.matches(CraftTweakerMC.getIItemStack(recipe.getValue().func_77571_b()))) continue;
                    toRemove.add(recipe.getKey());
                    continue;
                }
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.recipeName != null) {
                if (this.filter != null) {
                    return "Removing recipe with name \"" + this.recipeName + "\", Matching filter: " + this.filter.getDisplayName();
                }
                return "Removing recipe with name \"" + this.recipeName + "\"";
            }
            return "No name for the recipe to remove was given.";
        }
    }

    public static class ActionRemoveRecipesNoIngredients
    extends ActionBaseRemoveRecipes {
        private final List<Pair<IIngredient, Boolean>> outputs = new ArrayList<Pair<IIngredient, Boolean>>();

        public void addOutput(IIngredient output, @Optional boolean nbtMatch) {
            this.outputs.add((Pair<IIngredient, Boolean>)Pair.of((Object)output, (Object)nbtMatch));
        }

        @Override
        public void apply() {
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, IRecipe> recipe : recipes) {
                ItemStack recipeOutput = recipe.getValue().func_77571_b();
                IItemStack stack = CraftTweakerMC.getIItemStack(recipeOutput);
                if (stack == null || !this.matches(stack)) continue;
                toRemove.add(recipe.getKey());
            }
            super.removeRecipes(toRemove);
        }

        private boolean matches(IItemStack stack) {
            for (Pair<IIngredient, Boolean> entry : this.outputs) {
                IIngredient output = (IIngredient)entry.getKey();
                Boolean nbtMatch = (Boolean)entry.getValue();
                if (!(nbtMatch != false ? output.matchesExact(stack) : output.matches(stack))) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describe() {
            return "Removing recipes for various outputs";
        }
    }

    public static class ActionRemoveShapelessRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[] ingredients;
        boolean wildcard;

        public ActionRemoveShapelessRecipes(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
            this.output = output;
            this.ingredients = ingredients;
            this.wildcard = wildcard;
        }

        @Override
        public void apply() {
            if (this.output == null) {
                return;
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block0: for (Map.Entry<ResourceLocation, IRecipe> entry : recipes) {
                IRecipe recipe = entry.getValue();
                if (entry.getValue().func_77571_b().func_190926_b() || !this.output.matches(MCItemStack.createNonCopy(entry.getValue().func_77571_b())) || recipe instanceof IShapedRecipe || !(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
                if (this.ingredients != null) {
                    ShapelessRecipes srecipe;
                    if (recipe instanceof ShapelessRecipes) {
                        srecipe = (ShapelessRecipes)recipe;
                        if (this.ingredients.length > srecipe.func_192400_c().size() || !this.wildcard && this.ingredients.length < srecipe.func_192400_c().size()) continue;
                        block1: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(srecipe.field_77579_b.get(k), ingredient)) continue block1;
                            }
                            continue block0;
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        srecipe = (ShapelessOreRecipe)recipe;
                        NonNullList inputs = srecipe.func_192400_c();
                        if (inputs.size() < this.ingredients.length || !this.wildcard && inputs.size() > this.ingredients.length) continue;
                        block3: for (IIngredient ingredient : this.ingredients) {
                            for (int k = 0; k < srecipe.func_192400_c().size(); ++k) {
                                if (MCRecipeManager.matches(inputs.get(k), ingredient)) continue block3;
                            }
                            continue block0;
                        }
                    }
                }
                toRemove.add(entry.getKey());
            }
            CraftTweakerAPI.logInfo("Removing " + toRemove.size() + " Shapeless recipes.");
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shapeless recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static class ActionRemoveShapedRecipes
    extends ActionBaseRemoveRecipes {
        IIngredient output;
        IIngredient[][] ingredients;

        public ActionRemoveShapedRecipes(IIngredient output, IIngredient[][] ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }

        @Override
        public void apply() {
            int ingredientsWidth = 0;
            int ingredientsHeight = 0;
            if (this.ingredients != null) {
                ingredientsHeight = this.ingredients.length;
                for (IIngredient[] ingredient : this.ingredients) {
                    ingredientsWidth = Math.max(ingredientsWidth, ingredient.length);
                }
            }
            ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
            block1: for (Map.Entry<ResourceLocation, IRecipe> recipeEntry : recipes) {
                IRecipe recipe = recipeEntry.getValue();
                ItemStack output = recipe.func_77571_b();
                if (output.func_190926_b() || !this.output.matches(MCItemStack.createNonCopy(output)) || !(recipe instanceof IShapedRecipe)) continue;
                if (this.ingredients != null) {
                    IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
                    int width = shapedRecipe.getRecipeWidth();
                    int height = shapedRecipe.getRecipeHeight();
                    if (ingredientsWidth != width || ingredientsHeight != height) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = this.ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient = k > row.length ? null : row[k];
                            Ingredient ing = (Ingredient)shapedRecipe.func_192400_c().get(j * width + k);
                            ItemStack input = ing == Ingredient.field_193370_a || ing.test((Object)ItemStack.field_190927_a) || ing.func_193365_a().length == 0 ? ItemStack.field_190927_a : ing.func_193365_a()[0];
                            if (!MCRecipeManager.matches(input, ingredient)) continue block1;
                        }
                    }
                    toRemove.add(recipeEntry.getKey());
                    continue;
                }
                toRemove.add(recipeEntry.getKey());
            }
            CraftTweakerAPI.logInfo(toRemove.size() + " removed");
            super.removeRecipes(toRemove);
        }

        @Override
        public String describe() {
            if (this.output != null) {
                return "Removing Shaped recipes for " + this.output.toString();
            }
            return "Trying to remove recipes for invalid output";
        }
    }

    public static class ActionReplaceAllOccurences
    extends ActionBaseRemoveRecipes {
        private final IIngredient toReplace;
        private final IIngredient replaceWith;
        private final IIngredient forOutput;
        private List<MCRecipeBase> toChange;
        private List<ResourceLocation> toRemove;

        public ActionReplaceAllOccurences(IIngredient toReplace, IIngredient replaceWith, IIngredient forOutput) {
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
            this.forOutput = forOutput == null ? IngredientAny.INSTANCE : forOutput;
        }

        @Override
        public void apply() {
            this.toChange = this.getAllForIngredient(this.toReplace);
            this.toRemove = this.toChange.stream().map(f -> new ResourceLocation(f.getFullResourceName())).collect(Collectors.toList());
            this.removeRecipes(this.toRemove);
            this.changeIngredients(this.toChange);
        }

        @Override
        public void removeRecipes(List<ResourceLocation> removingRecipes) {
            ArrayList toUnAdd = new ArrayList();
            removingRecipes.forEach(recipe -> {
                RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe);
                recipesToAdd.stream().filter(f -> f instanceof ActionDummyAddRecipe).filter(f -> f.recipe.getRegistryName().equals(recipe)).forEach(toUnAdd::add);
            });
            toUnAdd.forEach(f -> {
                recipesToAdd.remove(f);
                usedRecipeNames.remove(f.getName());
            });
        }

        @Override
        public String describe() {
            return "Removing all occurences of ingredient: " + this.toReplace + " and replacing them with " + this.replaceWith;
        }

        private void changeIngredients(List<MCRecipeBase> toChange) {
            for (MCRecipeBase recipe : toChange) {
                MCRecipeBase newRecipe;
                IIngredient[][] ingredients;
                if (recipe.isShaped()) {
                    for (IIngredient[] targRow : ingredients = recipe.getIngredients2D()) {
                        for (int i = 0; i < targRow.length; ++i) {
                            if (targRow[i] == null || !targRow[i].contains(this.toReplace)) continue;
                            targRow[i] = this.replaceWith;
                        }
                    }
                    newRecipe = new MCRecipeShaped(ingredients, recipe.getOutput(), recipe.recipeFunction, recipe.getRecipeAction(), false, recipe.hidden);
                    this.registerNewRecipe(newRecipe, this.getNewRecipeName(recipe));
                    continue;
                }
                if (this.replaceWith == null) continue;
                ingredients = recipe.getIngredients1D();
                for (int i = 0; i < ingredients.length; ++i) {
                    IIngredient[] ingredient = ingredients[i];
                    if (ingredient == null || !ingredient.contains(this.toReplace)) continue;
                    ingredients[i] = this.replaceWith;
                }
                newRecipe = new MCRecipeShapeless((IIngredient[])ingredients, recipe.output, recipe.recipeFunction, recipe.recipeAction, recipe.hidden);
                this.registerNewRecipe(newRecipe, this.getNewRecipeName(recipe));
            }
        }

        private void registerNewRecipe(MCRecipeBase newRecipe, String name) {
            ActionDummyAddRecipe dummyRecipe = new ActionDummyAddRecipe(newRecipe, newRecipe.output, true);
            dummyRecipe.setName(name);
            recipesToAdd.add(dummyRecipe);
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)newRecipe);
        }

        private String getNewRecipeName(MCRecipeBase recipe) {
            if (recipe.getName().contains("modified")) {
                return recipe.getName().replace("modified", "remodified");
            }
            return recipe.getRegistryName().func_110624_b() + "-" + recipe.getName() + "-modified";
        }

        private List<MCRecipeBase> getAllForIngredient(IIngredient target) {
            ArrayList<MCRecipeBase> results = new ArrayList<MCRecipeBase>();
            Set recipes = ForgeRegistries.RECIPES.getEntries();
            block0: for (Map.Entry recipeEntry : recipes) {
                IRecipe recipe = (IRecipe)recipeEntry.getValue();
                IItemStack output = CraftTweakerMC.getIItemStack(recipe.func_77571_b());
                if (this.forOutput != IngredientAny.INSTANCE && output != null && !this.forOutput.matches(output)) continue;
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    IIngredient iIngredient = CraftTweakerMC.getIIngredient(ingredient);
                    if (iIngredient == null || !target.contains(iIngredient)) continue;
                    if (recipe instanceof MCRecipeBase) {
                        results.add((MCRecipeBase)recipe);
                        continue block0;
                    }
                    results.add(new MCRecipeWrapper(recipe));
                    continue block0;
                }
            }
            return results;
        }
    }

    public static abstract class ActionBaseRemoveRecipes
    implements IAction {
        public void removeRecipes(List<ResourceLocation> removingRecipes) {
            removingRecipes.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
        }
    }
}

