/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class IngredientStack
implements IIngredient {
    private final IIngredient ingredient;
    private final int amount;

    public IngredientStack(IIngredient ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public String getMark() {
        return this.ingredient.getMark();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<IItemStack> getItems() {
        return this.ingredient.getItems();
    }

    @Override
    public IItemStack[] getItemArray() {
        IItemStack[] stacks = this.ingredient.getItemArray();
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = stacks[i].withAmount(this.getAmount());
        }
        return stacks;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this.ingredient, amount);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        return new IngredientStack(this.ingredient.transformNew(transformer), this.amount);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientStack(this.ingredient.only(condition), this.amount);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientStack(this.ingredient.marked(mark), this.amount);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        return item.getAmount() >= this.getAmount() && this.ingredient.matches(item);
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        return item.getAmount() >= this.getAmount() && this.ingredient.matchesExact(item);
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        return this.ingredient.contains(ingredient);
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        return this.ingredient.applyTransform(item, byPlayer);
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        return this.ingredient.applyNewTransform(item);
    }

    @Override
    public Object getInternal() {
        return this.ingredient;
    }

    @Override
    public String toCommandString() {
        return this.ingredient.toCommandString() + " * " + this.amount;
    }

    @Override
    public boolean hasNewTransformers() {
        return this.ingredient.hasNewTransformers();
    }

    @Override
    public boolean hasTransformers() {
        return this.ingredient.hasTransformers();
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientStack(this.ingredient.transform(transformer), this.amount);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(",", "(Ingredients) ", "");
        for (IItemStack item : this.ingredient.getItems()) {
            stringJoiner.add(item.getName());
        }
        return stringJoiner.toString();
    }
}

