/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.render;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.powertools.machine.capbank.BlockCapBank;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.powertools.machine.capbank.render.IInfoRenderer;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class IoDisplay
implements IInfoRenderer {
    @Override
    public void render(@Nonnull TileCapBank cb, @Nonnull EnumFacing dir, float partialTick) {
        float offset;
        String text1;
        if (dir.func_96559_d() != 0) {
            return;
        }
        CapBankClientNetwork nw = (CapBankClientNetwork)cb.getNetwork();
        if (nw == null) {
            return;
        }
        CapBankClientNetwork.IOInfo info = nw.getIODisplayInfo(cb.func_174877_v(), dir);
        if (info.isInside()) {
            return;
        }
        int i = cb.func_145831_w().func_175626_b(cb.func_174877_v().func_177972_a(dir), 0);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        boolean drawBackground = true;
        if (drawBackground) {
            RenderUtil.bindBlockTexture();
            float scale = 0.85f;
            float offset2 = (1.0f - scale) / 2.0f;
            TextureAtlasSprite icon = BlockCapBank.getInfoPanelIcon();
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            switch (dir) {
                case NORTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2;
                    float x1 = (float)info.width - offset2;
                    float z0 = 0.0f;
                    vertices.add(new Vertex((double)x1, (double)y0, (double)z0, (double)minU, (double)minV, 0.0f, 0.0f, -1.0f));
                    vertices.add(new Vertex((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV, 0.0f, 0.0f, -1.0f));
                    vertices.add(new Vertex((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV, 0.0f, 0.0f, -1.0f));
                    vertices.add(new Vertex((double)x1, (double)y1, (double)z0, (double)minU, (double)maxV, 0.0f, 0.0f, -1.0f));
                    break;
                }
                case SOUTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2 - (float)(info.width - 1);
                    float x1 = 1.0f - offset2;
                    float z1 = 1.0f;
                    vertices.add(new Vertex((double)x0, (double)y0, (double)z1, (double)maxU, (double)minV, 0.0f, 0.0f, 1.0f));
                    vertices.add(new Vertex((double)x1, (double)y0, (double)z1, (double)minU, (double)minV, 0.0f, 0.0f, 1.0f));
                    vertices.add(new Vertex((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV, 0.0f, 0.0f, 1.0f));
                    vertices.add(new Vertex((double)x0, (double)y1, (double)z1, (double)maxU, (double)maxV, 0.0f, 0.0f, 1.0f));
                    break;
                }
                case EAST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2;
                    float z1 = (float)info.width - offset2;
                    float x1 = 1.0f;
                    vertices.add(new Vertex((double)x1, (double)y1, (double)z0, (double)maxU, (double)maxV, 1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV, 1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x1, (double)y0, (double)z1, (double)minU, (double)minV, 1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x1, (double)y0, (double)z0, (double)maxU, (double)minV, 1.0f, 0.0f, 0.0f));
                    break;
                }
                case WEST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2 - (float)(info.width - 1);
                    float z1 = 1.0f - offset2;
                    float x0 = 0.0f;
                    vertices.add(new Vertex((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV, -1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x0, (double)y0, (double)z1, (double)minU, (double)minV, -1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x0, (double)y1, (double)z1, (double)minU, (double)maxV, -1.0f, 0.0f, 0.0f));
                    vertices.add(new Vertex((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV, -1.0f, 0.0f, 0.0f));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.addVerticesToTessellator(vertices, (VertexFormat)DefaultVertexFormats.field_181710_j, (boolean)true);
            Tessellator.func_178181_a().func_78381_a();
        }
        nw.requestPowerUpdate(cb, 20);
        HeadingText heading1 = HeadingText.STABLE;
        HeadingText heading2 = null;
        String text2 = "";
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        float size = 0.15f * (float)Math.min(info.width, info.height);
        float scale = size / (float)fr.field_78288_b;
        if (info.height * 3 >= info.width * 4) {
            heading1 = HeadingText.INPUT;
            heading2 = HeadingText.OUTPUT;
            text1 = this.getChangeText(nw.getAverageInputPerTick(), fr);
            text2 = this.getChangeText(nw.getAverageOutputPerTick(), fr);
            offset = -size * 2.5f;
        } else {
            int change = Math.round(nw.getAverageChangePerTick());
            if (change > 0) {
                heading1 = HeadingText.GAIN;
            } else if (change < 0) {
                heading1 = HeadingText.LOSS;
            }
            text1 = this.getChangeText(change, fr);
            offset = -size;
        }
        EnumFacing right = dir.func_176732_a(EnumFacing.Axis.Y);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)dir.func_82601_c() * 1.02f / 2.0f + 0.5f + (float)(right.func_82601_c() * (info.width - 1)) * 0.5f), (float)(1.0f + size * 0.5f - (float)info.height * 0.5f), (float)((float)dir.func_82599_e() * 1.02f / 2.0f + 0.5f + (float)(right.func_82599_e() * (info.width - 1)) * 0.5f));
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (dir == EnumFacing.NORTH) {
            GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == EnumFacing.EAST) {
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == EnumFacing.WEST) {
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        offset = this.drawText(heading1, text1, offset, scale, size, fr);
        if (heading2 != null) {
            this.drawText(heading2, text2, offset, scale, size, fr);
        }
        RenderUtil.bindBlockTexture();
        GlStateManager.func_179084_k();
        GlStateManager.func_179113_r();
        GlStateManager.func_179121_F();
    }

    private float drawText(HeadingText heading, @Nonnull String text, float offset, float scale, float size, FontRenderer fr) {
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)offset, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(heading.text, -fr.func_78256_a(heading.text) / 2, 0, 0);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(offset += size * 1.5f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(text, -fr.func_78256_a(text) / 2, 0, heading.color);
        GlStateManager.func_179121_F();
        return offset += size * 1.5f;
    }

    @Nonnull
    protected String getChangeText(float average, FontRenderer fr) {
        int change = Math.round(Math.abs(average));
        String txt = LangPower.format(change);
        int width = fr.func_78256_a(txt);
        if (width > 38 && change > 1000) {
            txt = LangPower.format(change /= 1000) + "K";
        }
        return txt;
    }

    static enum HeadingText {
        STABLE(ColorUtil.getRGB((int)0, (int)0, (int)0)),
        GAIN(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        LOSS(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f)),
        INPUT(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        OUTPUT(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f));

        @Nonnull
        final String text = EnderIO.lang.localize("capbank.iodisplay.".concat(this.name().toLowerCase(Locale.US)));
        final int color;

        private HeadingText(int color) {
            this.color = color;
        }
    }
}

