/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.capacitor;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapacitorKeyType;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.ScalerFactory;
import crazypants.enderio.powertools.init.PowerToolObject;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderiopowertools")
public enum CapacitorKey implements ICapacitorKey
{
    POWER_MONITOR_POWER_INTAKE(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_INTAKE, "intake"),
    POWER_MONITOR_POWER_BUFFER(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_BUFFER, "buffer"),
    POWER_MONITOR_POWER_USE(PowerToolObject.block_power_monitor, CapacitorKeyType.ENERGY_USE, "use");

    @Nonnull
    private final ResourceLocation registryName;
    @Nonnull
    private final IModObject owner;
    @Nonnull
    private final CapacitorKeyType valueType;
    @Nonnull
    private Scaler scaler = ScalerFactory.INVALID;
    private int baseValue = Integer.MIN_VALUE;

    private CapacitorKey(@Nonnull IModObject owner, CapacitorKeyType valueType, String shortname) {
        this.owner = owner;
        this.valueType = valueType;
        this.registryName = new ResourceLocation(owner.getRegistryName().func_110624_b(), owner.getRegistryName().func_110623_a() + "/" + shortname.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public float getFloat(float level) {
        return (float)this.baseValue * this.scaler.scaleValue(level);
    }

    @Override
    public int getBaseValue() {
        return this.baseValue;
    }

    @Override
    @Nonnull
    public IModObject getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public CapacitorKeyType getValueType() {
        return this.valueType;
    }

    @Override
    @Nonnull
    public String getLegacyName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void setScaler(@Nonnull Scaler scaler) {
        this.scaler = scaler;
    }

    @Override
    public void setBaseValue(int baseValue) {
        this.baseValue = baseValue;
    }

    @Override
    public void validate() {
        if (this.scaler == ScalerFactory.INVALID || this.baseValue == Integer.MIN_VALUE) {
            throw new ICapacitorKey.UnconfiguredCapKeyException("CapacitorKey " + this.getRegistryName() + " has not been configured. This should not be possible and may be caused by a 3rd-party addon mod.");
        }
    }

    public final ICapacitorKey setRegistryName(String name) {
        throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
    }

    public final ICapacitorKey setRegistryName(ResourceLocation name) {
        throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
    }

    @Override
    @Nonnull
    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public final Class<ICapacitorKey> getRegistryType() {
        return ICapacitorKey.class;
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<ICapacitorKey> event) {
        for (CapacitorKey key : CapacitorKey.values()) {
            event.getRegistry().register((IForgeRegistryEntry)key);
            Log.debug("<capacitor key=\"", key.getRegistryName() + "\" base=\"\" scaler=\"\" />");
        }
    }
}

