/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.weather;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.obelisk.weather.TileWeatherObelisk;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketWeatherTank
extends MessageTileEntity<TileWeatherObelisk> {
    private NBTTagCompound tag;

    public PacketWeatherTank() {
    }

    public PacketWeatherTank(@Nonnull TileWeatherObelisk tile) {
        super((TileEntity)tile);
        this.tag = tile.getInputTank().writeToNBT(new NBTTagCompound());
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketWeatherTank, IMessage> {
        public IMessage onMessage(PacketWeatherTank message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileWeatherObelisk tile = (TileWeatherObelisk)message.getTileEntity(player.field_70170_p);
            if (tile != null) {
                tile.getInputTank().readFromNBT(message.tag);
            }
            return null;
        }
    }
}

