/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.buffer;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machines.machine.buffer.TileBuffer;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBufferIO
extends MessageTileEntity<TileBuffer> {
    private int in;
    private int out;

    public PacketBufferIO() {
    }

    public PacketBufferIO(@Nonnull TileBuffer tile, int in, int out) {
        super((TileEntity)tile);
        tile.setIO(in, out);
        this.in = in;
        this.out = out;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.in = buf.readInt();
        this.out = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.in);
        buf.writeInt(this.out);
    }

    public static class Handler
    implements IMessageHandler<PacketBufferIO, IMessage> {
        public IMessage onMessage(PacketBufferIO message, MessageContext ctx) {
            TileBuffer buf = (TileBuffer)message.getTileEntity(message.getWorld(ctx));
            if (buf != null) {
                buf.setIO(message.in, message.out);
            }
            return null;
        }
    }
}

