/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.fluids;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.integration.tic.fluids.MoltenEnder;
import crazypants.enderio.integration.tic.queues.TicRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Ender {
    private static final ResourceLocation TEX_STILL = new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow");
    private static final ResourceLocation TEX_FLOWING = new ResourceLocation("tconstruct:blocks/fluids/molten_metal");
    private static Fluid fluid;

    public static void createFluid() {
        fluid = new Fluid("ender", TEX_FLOWING, TEX_STILL){

            public int getColor() {
                return -14976149;
            }
        }.setUnlocalizedName("enderio.ender").setDensity(4000);
        fluid.setLuminosity(3).setTemperature(1273).setViscosity(35);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static Block createFluidBlock() {
        MoltenEnder block = new MoltenEnder(fluid, Material.field_151586_h, 1801067);
        block.setFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluid.getName()), 1000));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", fluid.getName());
        tag.func_74778_a("ore", "Ender");
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        Fluids.registerFluidBlockRendering(fluid);
    }

    public static void registerEnderRecipes() {
        Fluid f = FluidRegistry.getFluid((String)"ender");
        if (f != null) {
            TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(Items.field_151079_bi), f, 250.0f);
            Things cast = new Things(new String[]{"tconstruct:cast_custom:2"});
            TicRecipeHandler.instance.registerTableCast(new Things().add(Items.field_151079_bi), cast, f, 250.0f, false);
        }
        TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(crazypants.enderio.base.material.material.Material.POWDER_ENDER.getStack()), f, 27.0f);
    }
}

