/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.refinedstorage.conduit;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.fluid.items.IItemFilterFluidUpgrade;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.base.filter.item.items.ItemBasicItemFilter;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.refinedstorage.RSHelper;
import crazypants.enderio.conduits.refinedstorage.conduit.ConduitRefinedStorageNode;
import crazypants.enderio.conduits.refinedstorage.conduit.IRefinedStorageConduit;
import crazypants.enderio.conduits.refinedstorage.conduit.RefinedStorageConduitNetwork;
import crazypants.enderio.conduits.refinedstorage.conduit.gui.RefinedStorageSettings;
import crazypants.enderio.conduits.refinedstorage.init.ConduitRefinedStorageObject;
import crazypants.enderio.conduits.render.ConduitTexture;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class RefinedStorageConduit
extends AbstractConduit
implements IRefinedStorageConduit {
    static final Map<String, IConduitTexture> ICONS = new HashMap<String, IConduitTexture>();
    private Map<EnumFacing, ItemStack> upgrades = new EnumMap<EnumFacing, ItemStack>(EnumFacing.class);
    protected final EnumMap<EnumFacing, IFilter> outputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, IFilter> inputFilters = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    private ConduitRefinedStorageNode clientSideNode;
    protected RefinedStorageConduitNetwork network;

    public RefinedStorageConduit() {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.upgrades.put(dir, ItemStack.field_190927_a);
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
        }
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList<ItemStack> res = super.getDrops();
        for (ItemStack stack : this.upgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreConnectionMode) {
        TileEntity te = this.getBundle().getEntity();
        World world = te.func_145831_w();
        TileEntity test = world.func_175625_s(te.func_174877_v().func_177972_a(direction));
        if (test == null) {
            return false;
        }
        if (test.hasCapability(RSHelper.NETWORK_NODE_PROXY_CAPABILITY, direction.func_176734_d()) || test.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()) || test.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) {
            return true;
        }
        return super.canConnectToExternal(direction, ignoreConnectionMode);
    }

    @Override
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new RefinedStorageSettings(gui, con);
    }

    @Override
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof RefinedStorageSettings) {
            return ((RefinedStorageSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    public int getGuiPanelTabOrder() {
        return 4;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IRefinedStorageConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(ConduitRefinedStorageObject.item_refined_storage_conduit.getItemNN(), 1);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == RSHelper.NETWORK_NODE_PROXY_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == RSHelper.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)RSHelper.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean hasClientCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == RSHelper.NETWORK_NODE_PROXY_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getClientCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == RSHelper.NETWORK_NODE_PROXY_CAPABILITY) {
            return (T)RSHelper.NETWORK_NODE_PROXY_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Override
    public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY || capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY || capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    @Nonnull
    public RefinedStorageConduitNetwork createNetworkForType() {
        return new RefinedStorageConduitNetwork();
    }

    @Nullable
    public RefinedStorageConduitNetwork getNetwork() throws NullPointerException {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (RefinedStorageConduitNetwork)network;
        return super.setNetwork(network);
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Nonnull
    public ConduitRefinedStorageNode getNode() {
        World world = this.getBundle().getBundleworld();
        BlockPos pos = this.getBundle().getLocation();
        if (world.field_72995_K) {
            return this.clientSideNode != null ? this.clientSideNode : (this.clientSideNode = new ConduitRefinedStorageNode(this));
        }
        INetworkNodeManager manager = RSHelper.API.getNetworkNodeManager(world);
        INetworkNode node = manager.getNode(pos);
        if (node == null || !node.getId().equals("rs_conduit")) {
            node = new ConduitRefinedStorageNode(this);
            manager.setNode(pos, node);
            manager.markForSaving();
        }
        return (ConduitRefinedStorageNode)node;
    }

    @Override
    public void onAfterRemovedFromBundle() {
        super.onAfterRemovedFromBundle();
        BlockPos pos = this.getBundle().getLocation();
        INetworkNodeManager manager = RSHelper.API.getNetworkNodeManager(this.getBundle().getBundleworld());
        INetworkNode node = manager.getNode(pos);
        manager.removeNode(pos);
        manager.markForSaving();
        if (node != null && node.getNetwork() != null) {
            node.getNetwork().getNodeGraph().rebuild();
        }
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (ToolUtil.isToolEquipped(player, hand)) {
            CollidableComponent component;
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && (component = res.component) != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, ConnectionMode.IN_OUT);
                        return true;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.externalConnections.contains(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconnectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onAddedToBundle() {
        super.onAddedToBundle();
        World world = this.getBundle().getBundleworld();
        if (!world.field_72995_K) {
            RSHelper.API.discoverNode(world, this.getBundle().getLocation());
        }
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.getNode().onConduitConnectionChange();
    }

    @Override
    @Nonnull
    public ConnectionMode getNextConnectionMode(@Nonnull EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        mode = mode == ConnectionMode.IN_OUT ? ConnectionMode.DISABLED : ConnectionMode.IN_OUT;
        return mode;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IFilter filter;
        NBTTagCompound itemRoot2;
        IFilter f;
        ItemStack up;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, ItemStack> entry : this.upgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = entry.getValue();
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            up.func_77955_b(itemRoot22);
            nbtRoot.func_74782_a("upgrades." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = (IFilter)entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.outputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = (IFilter)entry.getValue())) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.inputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getInputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.outputFilterUpgrades.entrySet()) {
            if (entry.getValue() == null) continue;
            up = (ItemStack)entry.getValue();
            filter = this.getOutputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
    }

    private boolean isDefault(IFilter f) {
        if (f instanceof ItemFilter) {
            return ((ItemFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IFilter filter;
            NBTTagCompound filterTag;
            ItemStack ups;
            NBTTagCompound upTag;
            String key = "upgrades." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.upgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "inFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = FilterRegistry.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "inputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (!nbtRoot.func_74764_b(key = "outFilts." + dir.name())) continue;
            filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
            filter = FilterRegistry.loadFilterFromNbt(filterTag);
            this.outputFilters.put(dir, filter);
        }
    }

    @Override
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return ICONS.get("blocks/refined_storage_conduit_core");
        }
        return ICONS.get("blocks/refined_storage_conduit");
    }

    @Override
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeStack(int param1) {
        return this.upgrades.get(EnumFacing.func_82600_a((int)param1));
    }

    @Override
    public void setUpgradeStack(int param1, @Nonnull ItemStack stack) {
        this.upgrades.put(EnumFacing.func_82600_a((int)param1), stack);
    }

    @Override
    public IFilter getFilter(int filterId, int param1) {
        if (filterId == this.getInputFilterIndex()) {
            return this.getInputFilter(EnumFacing.func_82600_a((int)param1));
        }
        if (filterId == this.getOutputFilterIndex()) {
            return this.getOutputFilter(EnumFacing.func_82600_a((int)param1));
        }
        return null;
    }

    @Override
    public void setFilter(int filterId, int param1, @Nonnull IFilter filter) {
        if (filterId == this.getInputFilterIndex()) {
            this.setInputFilter(EnumFacing.func_82600_a((int)param1), filter);
        } else if (filterId == this.getOutputFilterIndex()) {
            this.setOutputFilter(EnumFacing.func_82600_a((int)param1), filter);
        }
    }

    @Override
    @Nonnull
    public ItemStack getFilterStack(int filterIndex, int param1) {
        if (filterIndex == this.getInputFilterIndex()) {
            return this.getInputFilterUpgrade(EnumFacing.func_82600_a((int)param1));
        }
        if (filterIndex == this.getOutputFilterIndex()) {
            return this.getOutputFilterUpgrade(EnumFacing.func_82600_a((int)param1));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setFilterStack(int filterIndex, int param1, @Nonnull ItemStack stack) {
        if (filterIndex == this.getInputFilterIndex()) {
            this.setInputFilterUpgrade(EnumFacing.func_82600_a((int)param1), stack);
        } else if (filterIndex == this.getOutputFilterIndex()) {
            this.setOutputFilterUpgrade(EnumFacing.func_82600_a((int)param1), stack);
        }
    }

    @Override
    public void setInputFilter(@Nonnull EnumFacing dir, @Nonnull IFilter filter) {
        this.inputFilters.put(dir, filter);
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilter(@Nonnull EnumFacing dir, @Nonnull IFilter filter) {
        this.outputFilters.put(dir, filter);
        this.setClientStateDirty();
    }

    @Override
    public IFilter getInputFilter(@Nonnull EnumFacing dir) {
        return this.inputFilters.get(dir);
    }

    @Override
    public IFilter getOutputFilter(@Nonnull EnumFacing dir) {
        return this.outputFilters.get(dir);
    }

    @Override
    public void setInputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.inputFilterUpgrades.put(dir, stack);
        this.setInputFilter(dir, (IFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.outputFilterUpgrades.put(dir, stack);
        this.setOutputFilter(dir, (IFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getInputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.inputFilterUpgrades.get(dir);
    }

    @Override
    @Nonnull
    public ItemStack getOutputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.outputFilterUpgrades.get(dir);
    }

    @Override
    public int getInputFilterIndex() {
        return 7;
    }

    @Override
    public int getOutputFilterIndex() {
        return 8;
    }

    @Override
    public boolean isFilterUpgradeAccepted(@Nonnull ItemStack stack, boolean isInput) {
        return stack.func_77973_b() instanceof IItemFilterFluidUpgrade || stack.func_77973_b() instanceof ItemBasicItemFilter;
    }

    static {
        ICONS.put("blocks/refined_storage_conduit", new ConduitTexture(TextureRegistry.registerTexture("blocks/refined_storage_conduit"), ConduitTexture.arm(0)));
        ICONS.put("blocks/refined_storage_conduit_core", new ConduitTexture(TextureRegistry.registerTexture("blocks/refined_storage_conduit_core"), ConduitTexture.core()));
    }
}

