/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.oc.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.conduits.gui.BaseSettingsPanel;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.oc.conduit.IOCConduit;
import crazypants.enderio.conduits.oc.init.ConduitOpenComputersObject;
import crazypants.enderio.conduits.oc.network.PacketHandler;
import crazypants.enderio.conduits.oc.network.PacketOCConduitSignalColor;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OCSettings
extends BaseSettingsPanel {
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    @Nonnull
    private ColorButton cb;
    @Nonnull
    private String signalColorStr = Lang.GUI_SIGNAL_COLOR.get();
    @Nonnull
    private final IOCConduit occon;

    public OCSettings(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        super(IconEIO.WRENCH_OVERLAY_OC, ConduitOpenComputersObject.item_opencomputers_conduit.getUnlocalisedName(), gui, con, "simple_settings");
        this.occon = (IOCConduit)con;
        int x = this.leftColumn;
        int y = this.customTop;
        this.cb = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x, y);
        this.cb.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        DyeColor sigCol = this.occon.getSignalColor(gui.getDir());
        this.cb.setColorIndex(sigCol.ordinal());
        x += this.cb.func_146117_b();
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.occon.setSignalColor(this.gui.getDir(), DyeColor.values()[this.cb.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOCConduitSignalColor(this.occon, this.gui.getDir()));
        }
    }

    @Override
    protected void initCustomOptions() {
        this.cb.setColorIndex(this.cb.getColorIndex());
        this.cb.onGuiInit();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.cb.detach();
    }

    @Override
    protected void renderCustomOptions(int topIn, float par1, int par2, int par3) {
        this.gui.getFontRenderer().func_78276_b(this.signalColorStr, this.left + this.leftColumn + 10, topIn + 2, ColorUtil.getRGB((Color)Color.darkGray));
    }

    @Override
    protected boolean hasInOutModes() {
        return false;
    }
}

