/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.util;

import crazypants.enderio.base.Log;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class DynaTextureProvider {
    @Nonnull
    protected static final Queue<ResourceLocation> toFree = new ConcurrentLinkedQueue<ResourceLocation>();
    @Nonnull
    protected static final List<DynaTextureProvider> instances = new ArrayList<DynaTextureProvider>();
    @Nonnull
    protected final ResourceLocation resourceLocation;
    @Nonnull
    protected final int[] imageData;
    protected boolean valid = true;
    @Nonnull
    protected final ResourceLocation fallBackTexture;
    @Nonnull
    protected final DynamicTexture dynamicTexture;
    @Nonnull
    protected final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    @Nonnull
    protected final IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();

    public DynaTextureProvider(int textureSize, @Nonnull ResourceLocation fallBackTexture) {
        this.fallBackTexture = fallBackTexture;
        this.dynamicTexture = new DynamicTexture(textureSize, textureSize);
        this.imageData = this.dynamicTexture.func_110565_c();
        this.resourceLocation = this.textureManager.func_110578_a("enderio", this.dynamicTexture);
        for (int i = 0; i < this.imageData.length; ++i) {
            this.imageData[i] = 0;
        }
        instances.add(this);
    }

    public void updateTexture() {
        if (this.valid) {
            this.updateTextureData();
            this.dynamicTexture.func_110564_a();
        }
    }

    protected abstract void updateTextureData();

    public void bindTexture() {
        if (this.valid) {
            this.textureManager.func_110577_a(this.resourceLocation);
        } else {
            this.textureManager.func_110577_a(this.fallBackTexture);
        }
    }

    public void free() {
        if (this.valid) {
            this.textureManager.func_147645_c(this.resourceLocation);
            this.valid = false;
        }
        ResourceLocation r = toFree.poll();
        while (r != null) {
            this.textureManager.func_147645_c(r);
            r = toFree.poll();
        }
    }

    protected void finalize() throws Throwable {
        if (this.valid) {
            toFree.add(this.resourceLocation);
            this.valid = false;
        }
        super.finalize();
    }

    @Nullable
    protected BufferedImage getTexture(@Nonnull ResourceLocation blockResource) {
        try {
            IResource iResource = this.resourceManager.func_110536_a(blockResource);
            BufferedImage image = ImageIO.read(iResource.func_110527_b());
            iResource.close();
            return image;
        }
        catch (IOException e) {
            Log.error("Failed to load " + blockResource + ": " + e);
            return null;
        }
    }

    @Nonnull
    protected BufferedImage resize(@Nonnull BufferedImage image, int size) {
        if (image.getWidth() != size) {
            BufferedImage resized = new BufferedImage(size, size, 2);
            Graphics2D g = resized.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(image, 0, 0, size, size, 0, 0, image.getWidth(), image.getHeight(), null);
            g.dispose();
            return resized;
        }
        return image;
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
    public static class Unloader {
        @SubscribeEvent
        public static void unload(WorldEvent.Unload event) {
            if (event.getWorld() instanceof WorldClient) {
                for (DynaTextureProvider instance : instances) {
                    instance.free();
                }
                instances.clear();
            }
        }
    }
}

