/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.model;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.render.model.CollectedQuadBakedBlockModel;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.pipeline.EnderItemOverrideList;
import crazypants.enderio.util.Profiler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;

public class RelayingBakedModel
implements IBakedModel {
    private IBakedModel defaults;
    private final boolean isTESRTransformsOnly;

    @Nonnull
    private IBakedModel getDefaults() {
        if (this.defaults == null) {
            try {
                this.defaults = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return (IBakedModel)NullHelper.notnullF((Object)this.defaults, (String)"missing model is missing");
    }

    @Nonnull
    public static RelayingBakedModel wrapModelForTESRRendering(IBakedModel model) {
        if (model instanceof RelayingBakedModel) {
            RelayingBakedModel rbm = (RelayingBakedModel)model;
            if (rbm.isTESRTransformsOnly) {
                return rbm;
            }
            return new RelayingBakedModel(rbm.defaults, true);
        }
        return new RelayingBakedModel(model, true);
    }

    public RelayingBakedModel(IBakedModel defaults, boolean isTESRTransformsOnly) {
        this.defaults = defaults;
        this.isTESRTransformsOnly = isTESRTransformsOnly;
    }

    public RelayingBakedModel(@Nonnull IBakedModel defaults) {
        this(defaults, false);
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        long start = Profiler.instance.start();
        if (state instanceof BlockStateWrapperBase) {
            IBakedModel model = ((BlockStateWrapperBase)state).getModel();
            if (model instanceof CollectedQuadBakedBlockModel) {
                ((CollectedQuadBakedBlockModel)model).setParticleTexture(this.func_177554_e());
            }
            if (model != null) {
                Profiler.instance.stop(start, state.func_177230_c().func_149732_F() + " (relayed)");
                return model.func_188616_a(state, side, rand);
            }
        }
        return this.getDefaults().func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.getDefaults().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getDefaults().func_177556_c();
    }

    public boolean func_188618_c() {
        return this.isTESRTransformsOnly;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.getDefaults().func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return EnderItemOverrideList.instance;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)this.getDefaults().handlePerspective(cameraTransformType).getRight());
    }
}

