/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.modes;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneMode
extends MessageTileEntity<TileEntity> {
    private RedstoneControlMode mode;

    public PacketRedstoneMode() {
    }

    public <T extends TileEntity> PacketRedstoneMode(@Nonnull T cont) {
        super(cont);
        this.mode = ((IRedstoneModeControlable)cont).getRedstoneControlMode();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort((int)((short)this.mode.ordinal()));
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ordinal = buf.readShort();
        this.mode = RedstoneControlMode.values()[ordinal];
    }

    public static class Handler
    implements IMessageHandler<PacketRedstoneMode, IMessage> {
        public IMessage onMessage(PacketRedstoneMode message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileEntity te = message.getTileEntity(player.field_70170_p);
            RedstoneControlMode mode = message.mode;
            if (mode != null && te instanceof IRedstoneModeControlable) {
                IRedstoneModeControlable me = (IRedstoneModeControlable)te;
                me.setRedstoneControlMode(mode);
            }
            return null;
        }
    }
}

