/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.thaumcraft;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.block.skull.SkullType;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.material.Material;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ThaumcraftAspects {
    private static int countItem = 0;
    private static int countOredict = 0;

    static void loadAspects() {
        Log.info("Thaumcraft integration: Adding aspects...");
        ThaumcraftAspects.registerObjectTag("dustCoal", new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151044_h)));
        ThaumcraftAspects.registerObjectTag("itemSilicon", new AspectList().add(Aspect.FIRE, 1).add(Aspect.ORDER, 1).add(Aspect.SENSES, 1));
        ThaumcraftAspects.registerObjectTag(Alloy.ELECTRICAL_STEEL.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects("dustCoal")).add(ThaumcraftAspects.getAspects(Items.field_151042_j)).add(ThaumcraftAspects.getAspects("itemSilicon")));
        ThaumcraftAspects.registerObjectTag(Alloy.ENERGETIC_ALLOY.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151114_aO)).add(ThaumcraftAspects.getAspects(Items.field_151137_ax)).add(ThaumcraftAspects.getAspects(Items.field_151043_k)));
        ThaumcraftAspects.registerObjectTag(Alloy.VIBRANT_ALLOY.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151079_bi)).add(ThaumcraftAspects.getAspects("ingotEnergeticAlloy")));
        ThaumcraftAspects.registerObjectTag(Alloy.REDSTONE_ALLOY.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151137_ax)).add(ThaumcraftAspects.getAspects("itemSilicon")));
        ThaumcraftAspects.registerObjectTag(Alloy.CONDUCTIVE_IRON.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151137_ax)).add(ThaumcraftAspects.getAspects(Items.field_151042_j)));
        ThaumcraftAspects.registerObjectTag(Alloy.PULSATING_IRON.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151079_bi)).add(ThaumcraftAspects.getAspects(Items.field_151042_j)));
        ThaumcraftAspects.registerObjectTag(Alloy.DARK_STEEL.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Items.field_151042_j)).add(ThaumcraftAspects.getAspects("dustCoal")).add(ThaumcraftAspects.getAspects(Blocks.field_150343_Z)));
        ThaumcraftAspects.registerObjectTag(Alloy.SOULARIUM.getOreIngot(), new AspectList().add(ThaumcraftAspects.getAspects(Blocks.field_150425_aM)).add(ThaumcraftAspects.getAspects(Items.field_151043_k)));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.blockEndermanSkull.getBlockNN(), 1, SkullType.TORMENTED.ordinal()), new AspectList().add(ThaumcraftAspects.getAspects(ModObject.blockEndermanSkull.getBlockNN())).add(ThaumcraftAspects.getAspects((Item)Items.field_151068_bn)).add(ThaumcraftAspects.getAspects((Item)Items.field_151068_bn)).add(ThaumcraftAspects.getAspects(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 0))).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.FRANKEN_ZOMBIE.ordinal()), new AspectList().add(ThaumcraftAspects.getAspects(new ItemStack(Items.field_151144_bL, 1, 2))).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 0))).add(ThaumcraftAspects.getAspects(Alloy.ENERGETIC_ALLOY.getOreIngot())).add(ThaumcraftAspects.getAspects(Alloy.ENERGETIC_ALLOY.getOreIngot())));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.FRANKEN_ZOMBIE.ordinal()), new AspectList().add(ThaumcraftAspects.getAspects(new ItemStack(Items.field_151144_bL, 1, 2))).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, 0))).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.FRANKEN_ZOMBIE.ordinal()), new AspectList().add(Aspect.UNDEAD, 2).add(Aspect.MAN, 1).add(Aspect.EARTH, 1).add(ThaumcraftAspects.getAspects(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.ZOMBIE_CONTROLLER.ordinal()))));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.ENDER_RESONATOR.ordinal()), new AspectList().add(ThaumcraftAspects.getAspects(ModObject.itemMaterial.getItemNN())).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects("itemSilicon")).add(ThaumcraftAspects.getAspects(Alloy.VIBRANT_ALLOY.getOreIngot())).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())).add(ThaumcraftAspects.getAspects(Alloy.SOULARIUM.getOreIngot())));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.ENDER_CRYSTAL.ordinal()), new AspectList().add(Aspect.AIR, 2).add(Aspect.ELDRITCH, 4).add(ThaumcraftAspects.getAspects(Items.field_151166_bC)));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.ATTRACTOR_CRYSTAL.ordinal()), new AspectList().add(Aspect.AIR, 2).add(Aspect.MAN, 3).add(ThaumcraftAspects.getAspects(new ItemStack(ModObject.itemMaterial.getItemNN(), 1, Material.VIBRANT_CRYSTAL.ordinal()))));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.blockFusedQuartz.getBlockNN(), 1), new AspectList().add(ThaumcraftAspects.getAspects(new ItemStack(Items.field_151128_bU, 4))).add(Aspect.CRYSTAL, 1));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.blockFusedGlass.getBlockNN(), 1), new AspectList().add(Aspect.CRYSTAL, 2));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.blockEnlightenedFusedQuartz.getBlockNN(), 1), new AspectList().add(ThaumcraftAspects.getAspects(new ItemStack(Items.field_151128_bU, 4))).add(Aspect.LIGHT, 8).add(Aspect.SENSES, 2));
        ThaumcraftAspects.registerObjectTag(new ItemStack(ModObject.blockEnlightenedFusedGlass.getBlockNN(), 1), new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.LIGHT, 8).add(Aspect.SENSES, 2));
        Log.info("Thaumcraft integration: Added aspects for " + countItem + " items and " + countOredict + " ore dictionary entrties");
    }

    @Nonnull
    private static AspectList getAspects(@Nonnull Block block) {
        return ThaumcraftAspects.getAspects(Item.func_150898_a((Block)block));
    }

    @Nonnull
    private static AspectList getAspects(@Nonnull String ore) {
        NonNullList ores = OreDictionary.getOres((String)ore);
        return ores.isEmpty() ? new AspectList() : ThaumcraftAspects.getAspects((ItemStack)NullHelper.notnullF(ores.get(0), (String)("oreDict " + ore + " has null stack")));
    }

    @Nonnull
    private static AspectList getAspects(@Nonnull Item item) {
        return ThaumcraftAspects.getAspects(new ItemStack(item));
    }

    @Nonnull
    private static AspectList getAspects(@Nonnull ItemStack item) {
        return new AspectList(item);
    }

    private static void registerObjectTag(@Nonnull String oreDict, AspectList aspects) {
        if (aspects.visSize() == 0) {
            Log.warn("Thaumcraft integration: No vis when adding aspects for " + oreDict);
        }
        ThaumcraftApi.registerObjectTag((String)oreDict, (AspectList)aspects);
        ++countOredict;
    }

    private static void registerObjectTag(@Nonnull ItemStack item, AspectList aspects) {
        if (aspects.visSize() == 0) {
            Log.warn("Thaumcraft integration: No vis when adding aspects for " + item);
        }
        ThaumcraftApi.registerObjectTag((ItemStack)item, (AspectList)aspects);
        ++countItem;
    }
}

