/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.jei;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.ItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IVanillaRecipeFactory;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DarkSteelUpgradeRecipeCategory {
    @Nonnull
    private static final Map<ItemStackKey, List<DarkSteelRecipeManager.UpgradePath>> allRecipes = (Map)NullHelper.notnullJ(DarkSteelRecipeManager.getAllRecipes(ItemHelper.getValidItems()).stream().collect(Collectors.groupingBy(rec -> new ItemStackKey(rec.getUpgrade()))), (String)"Stream#collect");

    public static void register(final IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(ModObject.blockDarkSteelAnvil.getBlockNN()), new String[]{"minecraft.anvil"});
        registry.addRecipeRegistryPlugin(new IRecipeRegistryPlugin(){

            @Nonnull
            public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory, @Nonnull IFocus<V> focus) {
                if (recipeCategory.getUid().equals("minecraft.anvil") && focus.getValue() instanceof ItemStack) {
                    Map<ItemStackKey, List<DarkSteelRecipeManager.UpgradePath>> recipes;
                    ItemStack focusStack = (ItemStack)focus.getValue();
                    if (focus.getMode() == IFocus.Mode.INPUT) {
                        if (focusStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150467_bQ) || focusStack.func_77973_b() == ModObject.blockDarkSteelAnvil.getItem()) {
                            recipes = allRecipes;
                        } else {
                            HashSet<DarkSteelRecipeManager.UpgradePath> res = new HashSet<DarkSteelRecipeManager.UpgradePath>();
                            DarkSteelRecipeManager.getRecipes(res, (NNList<ItemStack>)new NNList((Object[])new ItemStack[]{focusStack}));
                            recipes = res.stream().collect(Collectors.groupingBy(rec -> new ItemStackKey(rec.getUpgrade())));
                        }
                    } else {
                        HashMap<ItemStackKey, List<DarkSteelRecipeManager.UpgradePath>> temp = new HashMap<ItemStackKey, List<DarkSteelRecipeManager.UpgradePath>>();
                        for (Map.Entry e : allRecipes.entrySet()) {
                            temp.put((ItemStackKey)e.getKey(), ((List)e.getValue()).stream().filter(u -> u.getOutput().func_77973_b() == focusStack.func_77973_b()).collect(Collectors.toList()));
                        }
                        recipes = temp;
                    }
                    if (recipes.isEmpty()) {
                        return this.getWrappers(Collections.singletonList(allRecipes.get(new ItemStackKey(focusStack))));
                    }
                    return this.getWrappers(recipes);
                }
                return NNList.emptyList();
            }

            @Nonnull
            public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@Nonnull IRecipeCategory<T> recipeCategory) {
                if (recipeCategory.getUid().equals("minecraft.anvil")) {
                    return this.getWrappers(allRecipes);
                }
                return NNList.emptyList();
            }

            @Nonnull
            private List<ItemStack> extractRecipeElements(List<DarkSteelRecipeManager.UpgradePath> recs, Function<DarkSteelRecipeManager.UpgradePath, ItemStack> extractor) {
                return (List)NullHelper.notnullJ(recs.stream().map(extractor).collect(Collectors.toList()), (String)"Stream#collect");
            }

            @Nonnull
            private <T extends IRecipeWrapper> List<T> getWrappers(@Nonnull Map<ItemStackKey, List<DarkSteelRecipeManager.UpgradePath>> recipes) {
                return this.getWrappers(recipes.values());
            }

            @Nonnull
            private <T extends IRecipeWrapper> List<T> getWrappers(@Nonnull Collection<List<DarkSteelRecipeManager.UpgradePath>> recipes) {
                IVanillaRecipeFactory factory = registry.getJeiHelpers().getVanillaRecipeFactory();
                ArrayList<IRecipeWrapper> wrappers = new ArrayList<IRecipeWrapper>();
                for (List<DarkSteelRecipeManager.UpgradePath> recs : recipes) {
                    if (recs.isEmpty()) continue;
                    IRecipeWrapper w = factory.createAnvilRecipe(this.extractRecipeElements(recs, DarkSteelRecipeManager.UpgradePath::getInput), this.extractRecipeElements(recs, DarkSteelRecipeManager.UpgradePath::getUpgrade), this.extractRecipeElements(recs, DarkSteelRecipeManager.UpgradePath::getOutput));
                    wrappers.add(w);
                }
                return wrappers;
            }

            @Nonnull
            public <V> List<String> getRecipeCategoryUids(@Nonnull IFocus<V> focus) {
                return new NNList((Object[])new String[]{"minecraft.anvil"});
            }
        });
    }

    private static class ItemStackKey {
        @Nonnull
        final ItemStack wrapped;

        ItemStackKey(@Nonnull ItemStack stack) {
            this.wrapped = stack;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ItemStackKey.class) {
                return false;
            }
            ItemStack stack = ((ItemStackKey)obj).wrapped;
            return ItemStack.func_179545_c((ItemStack)this.wrapped, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.wrapped, (ItemStack)stack);
        }

        public int hashCode() {
            return Objects.hash(this.wrapped.func_77973_b(), this.wrapped.func_77952_i(), this.wrapped.func_77978_p());
        }
    }
}

